/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.sunsecure;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.rule.sunsecure.AbstractSunSecureRule;

public class MethodReturnsInternalArrayRule
extends AbstractSunSecureRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        if (!method.getResultType().returnsArray()) {
            return data;
        }
        List<ASTReturnStatement> returns = method.findDescendantsOfType(ASTReturnStatement.class);
        ASTTypeDeclaration td = method.getFirstParentOfType(ASTTypeDeclaration.class);
        for (ASTReturnStatement ret : returns) {
            ASTPrimarySuffix ps;
            String vn = this.getReturnedVariableName(ret);
            if (!this.isField(vn, td) || ret.findDescendantsOfType(ASTPrimarySuffix.class).size() > 2 || ret.hasDescendantOfType(ASTAllocationExpression.class)) continue;
            if (!this.isLocalVariable(vn, method)) {
                this.addViolation(data, (Node)ret, vn);
                continue;
            }
            ASTPrimaryPrefix pp = ret.getFirstDescendantOfType(ASTPrimaryPrefix.class);
            if (pp == null || !pp.usesThisModifier() || !(ps = ret.getFirstDescendantOfType(ASTPrimarySuffix.class)).hasImageEqualTo(vn)) continue;
            this.addViolation(data, (Node)ret, vn);
        }
        return data;
    }
}

