/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class ClassScope
extends AbstractJavaScope {
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private String className;

    public ClassScope(String className) {
        this.className = className;
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.getDeclarations(MethodNameDeclaration.class);
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    @Override
    public NameDeclaration addNameOccurrence(NameOccurrence occurrence) {
        JavaNameOccurrence javaOccurrence = (JavaNameOccurrence)occurrence;
        NameDeclaration decl = this.findVariableHere(javaOccurrence);
        if (decl != null && (javaOccurrence.isMethodOrConstructorInvocation() || javaOccurrence.isMethodReference())) {
            List<NameOccurrence> nameOccurrences = this.getMethodDeclarations().get(decl);
            if (nameOccurrences != null) {
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        } else if (decl != null && !javaOccurrence.isThisOrSuper()) {
            List<NameOccurrence> nameOccurrences = this.getVariableDeclarations().get(decl);
            if (nameOccurrences == null) {
                for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                    Scope innerClassScope = innerClass.getScope();
                    if (!innerClassScope.contains(javaOccurrence)) continue;
                    innerClassScope.addNameOccurrence(javaOccurrence);
                }
            } else {
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        }
        return decl;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    protected NameDeclaration findVariableHere(JavaNameOccurrence occurrence) {
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations = this.getMethodDeclarations();
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations = this.getVariableDeclarations();
        if (occurrence.isThisOrSuper() || occurrence.getImage() != null && occurrence.getImage().equals(this.className)) {
            if (variableDeclarations.isEmpty() && methodDeclarations.isEmpty()) {
                return null;
            }
            if (!variableDeclarations.isEmpty()) {
                return variableDeclarations.keySet().iterator().next();
            }
            return methodDeclarations.keySet().iterator().next();
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                List<String> parameterTypes = this.determineParameterTypes(mnd);
                List<String> argumentTypes = this.determineArgumentTypes(occurrence, parameterTypes);
                if (!mnd.isVarargs() && occurrence.getArgumentCount() == mnd.getParameterCount() && parameterTypes.equals(argumentTypes)) {
                    return mnd;
                }
                if (!mnd.isVarargs()) continue;
                int varArgIndex = parameterTypes.size() - 1;
                String varArgType = parameterTypes.get(varArgIndex);
                if (!parameterTypes.subList(0, varArgIndex).equals(argumentTypes.subList(0, varArgIndex))) continue;
                boolean sameType = true;
                for (int i = varArgIndex; i < argumentTypes.size(); ++i) {
                    if (varArgType.equals(argumentTypes.get(i))) continue;
                    sameType = false;
                    break;
                }
                if (!sameType) continue;
                return mnd;
            }
            return null;
        }
        if (occurrence.isMethodReference()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                return mnd;
            }
            return null;
        }
        ArrayList<String> images = new ArrayList<String>();
        if (occurrence.getImage() != null) {
            images.add(occurrence.getImage());
            if (occurrence.getImage().startsWith(this.className)) {
                images.add(this.clipClassName(occurrence.getImage()));
            }
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, variableDeclarations.keySet().iterator());
        NameDeclaration result = finder.getDecl();
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (result == null && !classDeclarations.isEmpty()) {
            for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                Applier.apply(finder, innerClass.getScope().getDeclarations().keySet().iterator());
                result = finder.getDecl();
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    private List<String> determineParameterTypes(MethodNameDeclaration mnd) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        List<ASTFormalParameter> parameters = mnd.getMethodNameDeclaratorNode().findDescendantsOfType(ASTFormalParameter.class);
        for (ASTFormalParameter p : parameters) {
            parameterTypes.add(p.getTypeNode().getTypeImage());
        }
        return parameterTypes;
    }

    private List<String> determineArgumentTypes(JavaNameOccurrence occurrence, List<String> parameterTypes) {
        int i;
        String unknown_type = "unknown";
        ArrayList<String> argumentTypes = new ArrayList<String>();
        ASTArgumentList arguments = occurrence.getLocation().jjtGetParent().jjtGetParent().getFirstDescendantOfType(ASTArgumentList.class);
        if (arguments != null) {
            for (i = 0; i < arguments.jjtGetNumChildren(); ++i) {
                ASTName name = arguments.jjtGetChild(i).getFirstDescendantOfType(ASTName.class);
                String typeImage = "unknown";
                if (name != null) {
                    Scope s;
                    for (s = name.getScope(); s != null && !s.contains(new JavaNameOccurrence(name, name.getImage())); s = s.getParent()) {
                    }
                    if (s != null) {
                        Map<VariableNameDeclaration, List<NameOccurrence>> vars = s.getDeclarations(VariableNameDeclaration.class);
                        for (VariableNameDeclaration d : vars.keySet()) {
                            if (!d.getImage().equals(name.getImage())) continue;
                            typeImage = d.getTypeImage();
                            break;
                        }
                    }
                } else {
                    ASTLiteral literal = arguments.jjtGetChild(i).getFirstDescendantOfType(ASTLiteral.class);
                    if (literal != null) {
                        if (literal.isCharLiteral()) {
                            typeImage = "char";
                        } else if (literal.isStringLiteral()) {
                            typeImage = "String";
                        } else if (literal.isFloatLiteral()) {
                            typeImage = "float";
                        } else if (literal.isIntLiteral()) {
                            typeImage = "int";
                        }
                    }
                }
                argumentTypes.add(typeImage);
            }
        }
        for (i = 0; i < argumentTypes.size() && i < parameterTypes.size(); ++i) {
            if (!"unknown".equals(argumentTypes.get(i))) continue;
            argumentTypes.set(i, parameterTypes.get(i));
        }
        return argumentTypes;
    }

    public String toString() {
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations;
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations;
        StringBuilder res = new StringBuilder("ClassScope (").append(this.className).append("): ");
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (classDeclarations.isEmpty()) {
            res.append("Inner Classes ").append(this.glomNames(classDeclarations.keySet())).append("; ");
        }
        if (!(methodDeclarations = this.getMethodDeclarations()).isEmpty()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                res.append(mnd.toString());
                int usages = methodDeclarations.get(mnd).size();
                res.append("(begins at line ").append(mnd.getNode().getBeginLine()).append(", ").append(usages).append(" usages)");
                res.append(", ");
            }
        }
        if (!(variableDeclarations = this.getVariableDeclarations()).isEmpty()) {
            res.append("Variables ").append(this.glomNames(variableDeclarations.keySet()));
        }
        return res.toString();
    }

    private String clipClassName(String s) {
        return s.substring(s.indexOf(46) + 1);
    }
}

