/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPostfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class JavaNameOccurrence
implements NameOccurrence {
    private JavaNode location;
    private String image;
    private NameOccurrence qualifiedName;
    private boolean isMethodOrConstructorInvocation;
    private int argumentCount;
    private static final String THIS = "this";
    private static final String SUPER = "super";
    private static final String THIS_DOT = "this.";
    private static final String SUPER_DOT = "super.";

    public JavaNameOccurrence(JavaNode location, String image) {
        this.location = location;
        this.image = image;
    }

    public void setIsMethodOrConstructorInvocation() {
        this.isMethodOrConstructorInvocation = true;
    }

    public void setArgumentCount(int count) {
        this.argumentCount = count;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public boolean isMethodOrConstructorInvocation() {
        return this.isMethodOrConstructorInvocation;
    }

    public boolean isMethodReference() {
        return this.location instanceof ASTMethodReference;
    }

    public void setNameWhichThisQualifies(NameOccurrence qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public NameOccurrence getNameForWhichThisIsAQualifier() {
        return this.qualifiedName;
    }

    public boolean isPartOfQualifiedName() {
        return this.qualifiedName != null;
    }

    @Override
    public JavaNode getLocation() {
        return this.location;
    }

    public boolean isOnRightHandSide() {
        Node node = this.location.jjtGetParent().jjtGetParent().jjtGetParent();
        return node instanceof ASTExpression && node.jjtGetNumChildren() == 3;
    }

    public boolean isOnLeftHandSide() {
        Node primaryExpression;
        if (this.location.jjtGetParent() instanceof ASTPrimaryExpression) {
            primaryExpression = this.location.jjtGetParent().jjtGetParent();
        } else if (this.location.jjtGetParent().jjtGetParent() instanceof ASTPrimaryExpression) {
            primaryExpression = this.location.jjtGetParent().jjtGetParent().jjtGetParent();
        } else {
            throw new RuntimeException("Found a NameOccurrence that didn't have an ASTPrimary Expression as parent or grandparent.  Parent = " + this.location.jjtGetParent() + " and grandparent = " + this.location.jjtGetParent().jjtGetParent());
        }
        if (this.isStandAlonePostfix(primaryExpression)) {
            return true;
        }
        if (primaryExpression.jjtGetNumChildren() <= 1) {
            return false;
        }
        if (!(primaryExpression.jjtGetChild(1) instanceof ASTAssignmentOperator)) {
            return false;
        }
        if (this.isPartOfQualifiedName()) {
            return false;
        }
        return !this.isCompoundAssignment(primaryExpression);
    }

    private boolean isCompoundAssignment(Node primaryExpression) {
        return ((ASTAssignmentOperator)primaryExpression.jjtGetChild(1)).isCompound();
    }

    private boolean isStandAlonePostfix(Node primaryExpression) {
        if (!(primaryExpression instanceof ASTPostfixExpression) || !(primaryExpression.jjtGetParent() instanceof ASTStatementExpression)) {
            return false;
        }
        ASTPrimaryPrefix pf = (ASTPrimaryPrefix)((ASTPrimaryExpression)primaryExpression.jjtGetChild(0)).jjtGetChild(0);
        if (pf.usesThisModifier()) {
            return true;
        }
        return this.thirdChildHasDottedName(primaryExpression);
    }

    private boolean thirdChildHasDottedName(Node primaryExpression) {
        Node thirdChild = primaryExpression.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0);
        return thirdChild instanceof ASTName && ((ASTName)thirdChild).getImage().indexOf(46) == -1;
    }

    public boolean isSelfAssignment() {
        Node gp;
        Node l = this.location;
        while (true) {
            Node p;
            Node node;
            if ((node = (gp = (p = l.jjtGetParent()).jjtGetParent()).jjtGetParent()) instanceof ASTPreDecrementExpression || node instanceof ASTPreIncrementExpression || node instanceof ASTPostfixExpression) {
                return true;
            }
            if (this.hasAssignmentOperator(gp)) {
                return this.isCompoundAssignment(gp);
            }
            if (this.hasAssignmentOperator(node)) {
                return this.isCompoundAssignment(node);
            }
            if (!(p instanceof ASTPrimaryPrefix) || p.jjtGetNumChildren() != 1 || !(gp instanceof ASTPrimaryExpression) || gp.jjtGetNumChildren() != 1 || !(node instanceof ASTExpression) || node.jjtGetNumChildren() != 1 || !(node.jjtGetParent() instanceof ASTPrimaryPrefix) || node.jjtGetParent().jjtGetNumChildren() != 1) break;
            l = node;
        }
        return gp instanceof ASTPreDecrementExpression || gp instanceof ASTPreIncrementExpression || gp instanceof ASTPostfixExpression;
    }

    private boolean hasAssignmentOperator(Node node) {
        return (node instanceof ASTStatementExpression || node instanceof ASTExpression) && node.jjtGetNumChildren() >= 2 && node.jjtGetChild(1) instanceof ASTAssignmentOperator;
    }

    public boolean isThisOrSuper() {
        return this.image != null && (this.image.equals(THIS) || this.image.equals(SUPER));
    }

    public boolean useThisOrSuper() {
        ASTPrimaryExpression primaryExpression;
        ASTPrimaryPrefix prefix;
        Node node = this.location.jjtGetParent();
        if (node instanceof ASTPrimaryExpression && (prefix = (ASTPrimaryPrefix)(primaryExpression = (ASTPrimaryExpression)node).jjtGetChild(0)) != null) {
            return prefix.usesSuperModifier() || prefix.usesThisModifier();
        }
        return this.image.startsWith(THIS_DOT) || this.image.startsWith(SUPER_DOT);
    }

    public boolean equals(Object o) {
        if (o instanceof JavaNameOccurrence) {
            JavaNameOccurrence n = (JavaNameOccurrence)o;
            return n.getImage().equals(this.getImage());
        }
        return false;
    }

    public int hashCode() {
        return this.getImage().hashCode();
    }

    @Override
    public String getImage() {
        return this.image;
    }

    public String toString() {
        return this.getImage() + ":" + this.location.getBeginLine() + ":" + this.location.getClass() + (this.isMethodOrConstructorInvocation() ? "(method call)" : "");
    }
}

