/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class MethodScope
extends AbstractJavaScope {
    private Node node;

    public MethodScope(Node node) {
        this.node = node;
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    @Override
    public NameDeclaration addNameOccurrence(NameOccurrence occurrence) {
        JavaNameOccurrence javaOccurrence = (JavaNameOccurrence)occurrence;
        NameDeclaration decl = this.findVariableHere(javaOccurrence);
        if (decl != null && !javaOccurrence.isThisOrSuper()) {
            this.getVariableDeclarations().get(decl).add(javaOccurrence);
            JavaNode n = javaOccurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    @Override
    public void addDeclaration(NameDeclaration variableDecl) {
        if (!(variableDecl instanceof VariableNameDeclaration) && !(variableDecl instanceof ClassNameDeclaration)) {
            throw new IllegalArgumentException("A MethodScope can contain only VariableNameDeclarations or ClassNameDeclarations");
        }
        super.addDeclaration(variableDecl);
    }

    @Override
    public NameDeclaration findVariableHere(JavaNameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.isMethodOrConstructorInvocation()) {
            return null;
        }
        ImageFinderFunction finder = new ImageFinderFunction(occurrence.getImage());
        Applier.apply(finder, this.getVariableDeclarations().keySet().iterator());
        return finder.getDecl();
    }

    public String getName() {
        if (this.node instanceof ASTConstructorDeclaration) {
            return this.getEnclosingScope(ClassScope.class).getClassName();
        }
        return this.node.jjtGetChild(1).getImage();
    }

    public String toString() {
        return "MethodScope:" + this.glomNames(this.getVariableDeclarations().keySet());
    }
}

