/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.Stack;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.LocalScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class ScopeAndDeclarationFinder
extends JavaParserVisitorAdapter {
    private Stack<Scope> scopes = new Stack();

    private void addScope(Scope newScope, JavaNode node) {
        newScope.setParent(this.scopes.peek());
        this.scopes.push(newScope);
        node.setScope(newScope);
    }

    private void createLocalScope(JavaNode node) {
        this.addScope(new LocalScope(), node);
    }

    private void createMethodScope(JavaNode node) {
        this.addScope(new MethodScope(node), node);
    }

    private void createClassScope(JavaNode node) {
        if (node instanceof ASTClassOrInterfaceBodyDeclaration) {
            this.addScope(new ClassScope(), node);
        } else {
            this.addScope(new ClassScope(node.getImage()), node);
        }
    }

    private void createSourceFileScope(ASTCompilationUnit node) {
        ASTPackageDeclaration n = node.getPackageDeclaration();
        SourceFileScope scope = n != null ? new SourceFileScope(n.jjtGetChild(0).getImage()) : new SourceFileScope();
        this.scopes.push(scope);
        node.setScope(scope);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.createSourceFileScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.createClassScope(node);
        Scope s = ((JavaNode)node.jjtGetParent()).getScope();
        s.addDeclaration(new ClassNameDeclaration(node));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.createClassScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        this.createClassScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceBodyDeclaration node, Object data) {
        if (node.isAnonymousInnerClass() || node.isEnumChild()) {
            this.createClassScope(node);
            this.cont(node);
        } else {
            super.visit(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTCatchStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTFinallyStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.createMethodScope(node);
        Scope methodScope = node.getScope();
        Node formalParameters = node.jjtGetChild(0);
        int i = 1;
        int n = node.jjtGetNumChildren();
        if (!(formalParameters instanceof ASTFormalParameters)) {
            this.visit((ASTTypeParameters)formalParameters, data);
            formalParameters = node.jjtGetChild(1);
            ++i;
        }
        this.visit((ASTFormalParameters)formalParameters, data);
        Scope localScope = null;
        while (i < n) {
            JavaNode b = (JavaNode)node.jjtGetChild(i);
            if (b instanceof ASTBlockStatement) {
                if (localScope == null) {
                    this.createLocalScope(node);
                    localScope = node.getScope();
                }
                b.setScope(localScope);
                this.visit(b, data);
            } else {
                this.visit(b, data);
            }
            ++i;
        }
        if (localScope != null) {
            this.scopes.pop();
            node.setScope(methodScope);
        }
        this.scopes.pop();
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.createMethodScope(node);
        ASTMethodDeclarator md = node.getFirstChildOfType(ASTMethodDeclarator.class);
        node.getScope().getEnclosingScope(ClassScope.class).addDeclaration(new MethodNameDeclaration(md));
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        VariableNameDeclaration decl = new VariableNameDeclaration(node);
        node.getScope().addDeclaration(decl);
        node.setNameDeclaration(decl);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        this.createLocalScope(node);
        this.cont(node);
        return data;
    }

    private void cont(AbstractJavaNode node) {
        super.visit(node, null);
        this.scopes.pop();
    }
}

