/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.ast;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.sourceforge.pmd.lang.plsql.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.plsql.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserVisitorAdapter;

public class DumpFacade
extends PLSQLParserVisitorAdapter {
    private PrintWriter writer;
    private boolean recurse;

    public void initializeWith(Writer writer, String prefix, boolean recurse, PLSQLNode node) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.recurse = recurse;
        this.visit(node, (Object)prefix);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem flushing PrintWriter.", e);
        }
    }

    @Override
    public Object visit(PLSQLNode node, Object data) {
        this.dump(node, (String)data);
        if (this.recurse) {
            return super.visit(node, (Object)(data + " "));
        }
        return data;
    }

    private void dump(PLSQLNode node, String prefix) {
        ASTPrimarySuffix primarySuffix;
        this.writer.print(prefix);
        this.writer.print(node.toString());
        String image = node.getImage();
        if (node instanceof ASTBooleanLiteral) {
            image = node.getImage();
        } else if (node instanceof ASTPrimaryPrefix) {
            ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)node;
            String result = null;
            if (image != null) {
                result = result + "." + image;
            }
            image = result;
        } else if (node instanceof ASTPrimarySuffix && (primarySuffix = (ASTPrimarySuffix)node).isArrayDereference()) {
            image = image == null ? "[" : "[" + image;
        }
        ArrayList extras = new ArrayList();
        if (image != null || !extras.isEmpty()) {
            this.writer.print(':');
            if (image != null) {
                this.writer.print(image);
            }
            for (String extra : extras) {
                this.writer.print('(');
                this.writer.print(extra);
                this.writer.print(')');
            }
        }
        this.writer.println();
    }
}

