/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.util.logging.Logger;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.rule.AbstractStatisticalPLSQLRule;
import net.sourceforge.pmd.stat.DataPoint;

public class ExcessiveLengthRule
extends AbstractStatisticalPLSQLRule {
    private static final Logger LOGGER = Logger.getLogger(ExcessiveLengthRule.class.getName());
    private Class<?> nodeClass;

    public ExcessiveLengthRule(Class<?> nodeClass) {
        this.nodeClass = nodeClass;
    }

    @Override
    public Object visit(PLSQLNode node, Object data) {
        LOGGER.finest("SimpleNode: line " + node.getBeginLine() + ", column " + node.getBeginColumn() + " - is node " + node.getClass().getCanonicalName() + " instanceof " + this.nodeClass.getClass().getCanonicalName());
        if (this.nodeClass.isInstance(node)) {
            LOGGER.finest("SimpleNode: YES node " + node.getClass().getCanonicalName() + " IS instanceof " + this.nodeClass.getClass().getCanonicalName() + " with  length == (" + node.getEndLine() + " - " + node.getBeginLine() + " == " + (node.getEndLine() - node.getBeginLine()));
            DataPoint point = new DataPoint();
            point.setNode(node);
            point.setScore(1.0 * (double)(node.getEndLine() - node.getBeginLine()));
            point.setMessage(this.getMessage());
            this.addDataPoint(point);
            LOGGER.fine("SimpleNode: Score " + point.getScore() + " for " + this.nodeClass.getCanonicalName());
        }
        return node.childrenAccept(this, data);
    }

    @Override
    public Object[] getViolationParameters(DataPoint point) {
        return new String[]{String.valueOf((int)point.getScore())};
    }
}

