/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.symboltable;

import java.util.logging.Logger;
import net.sourceforge.pmd.lang.plsql.ast.ASTVariableOrConstantDeclaratorId;
import net.sourceforge.pmd.lang.plsql.symboltable.ClassScope;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class VariableNameDeclaration
extends AbstractNameDeclaration {
    private static final Logger LOGGER = Logger.getLogger(VariableNameDeclaration.class.getName());

    public VariableNameDeclaration(ASTVariableOrConstantDeclaratorId node) {
        super(node);
    }

    @Override
    public Scope getScope() {
        try {
            return this.node.getScope().getEnclosingScope(ClassScope.class);
        }
        catch (Exception e) {
            LOGGER.finest("This Node does not have an enclosing Class: " + this.node.getBeginLine() + "/" + this.node.getBeginColumn() + " => " + this.getImage());
            return null;
        }
    }

    public ASTVariableOrConstantDeclaratorId getDeclaratorId() {
        return (ASTVariableOrConstantDeclaratorId)this.node;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableNameDeclaration)) {
            return false;
        }
        VariableNameDeclaration n = (VariableNameDeclaration)o;
        try {
            return n.getImage().equals(this.getImage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            LOGGER.finest("n.node=" + n.node);
            LOGGER.finest("n.getImage=" + n.getImage());
            LOGGER.finest("node=" + this.node);
            LOGGER.finest("this.getImage=" + this.getImage());
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getImage().hashCode();
        }
        catch (Exception e) {
            LOGGER.finest("VariableNameDeclaration: node=" + this.node);
            LOGGER.finest("VariableNameDeclaration: node,getImage=" + this.getImage());
            return 0;
        }
    }

    public String toString() {
        return "Variable: image = '" + this.node.getImage() + "', line = " + this.node.getBeginLine();
    }
}

