/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.lang.rule.properties.AbstractProperty;

public abstract class AbstractDelimitedProperty<T>
extends AbstractProperty<T> {
    private char multiValueDelimiter;
    private static final String DELIM_ID = "delimiter";

    protected AbstractDelimitedProperty(String theName, String theDescription, T theDefault, char delimiter, float theUIOrder) {
        super(theName, theDescription, theDefault, theUIOrder);
        this.multiValueDelimiter = delimiter;
    }

    protected static char delimiterIn(Map<String, String> parameters) {
        if (!parameters.containsKey(DELIM_ID)) {
            throw new IllegalArgumentException("missing delimiter value");
        }
        return parameters.get(DELIM_ID).charAt(0);
    }

    @Override
    protected void addAttributesTo(Map<String, String> attributes) {
        super.addAttributesTo(attributes);
        attributes.put(DELIM_ID, Character.toString(this.multiValueDelimiter));
    }

    @Override
    protected String defaultAsString() {
        return this.asDelimitedString(this.defaultValue(), this.multiValueDelimiter);
    }

    protected void multiValueDelimiter(char aDelimiter) {
        this.multiValueDelimiter = aDelimiter;
    }

    @Override
    public char multiValueDelimiter() {
        return this.multiValueDelimiter;
    }

    @Override
    public boolean isMultiValue() {
        return true;
    }
}

