/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.NumericPropertyDescriptor;
import net.sourceforge.pmd.lang.rule.properties.AbstractScalarProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

public abstract class AbstractNumericProperty<T>
extends AbstractScalarProperty<T>
implements NumericPropertyDescriptor<T> {
    private Number lowerLimit;
    private Number upperLimit;
    public static final Map<String, Boolean> numberFieldTypesByKey = BasicPropertyDescriptorFactory.expectedFieldTypesWith(new String[]{"min", "max"}, new Boolean[]{Boolean.TRUE, Boolean.TRUE});

    protected AbstractNumericProperty(String theName, String theDescription, Number lower, Number upper, T theDefault, float theUIOrder) {
        super(theName, theDescription, theDefault, theUIOrder);
        if (lower.doubleValue() > upper.doubleValue()) {
            throw new IllegalArgumentException("Lower limit cannot be greater than the upper limit");
        }
        this.lowerLimit = lower;
        this.upperLimit = upper;
    }

    @Override
    public Number lowerLimit() {
        return this.lowerLimit;
    }

    @Override
    protected String defaultAsString() {
        return this.defaultValue().toString();
    }

    @Override
    public Number upperLimit() {
        return this.upperLimit;
    }

    public String rangeString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(this.lowerLimit);
        sb.append(" -> ").append(this.upperLimit);
        sb.append(')');
        return sb.toString();
    }

    @Override
    protected String valueErrorFor(Object value) {
        double number = ((Number)value).doubleValue();
        if (number > this.upperLimit.doubleValue() || number < this.lowerLimit.doubleValue()) {
            return value + " is out of range " + this.rangeString();
        }
        return null;
    }

    @Override
    protected void addAttributesTo(Map<String, String> attributes) {
        super.addAttributesTo(attributes);
        attributes.put("min", this.lowerLimit.toString());
        attributes.put("max", this.upperLimit.toString());
    }
}

