/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Enumeration;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractEnumeratedProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;
import net.sourceforge.pmd.util.StringUtil;

public class EnumeratedMultiProperty<E>
extends AbstractEnumeratedProperty<E, Object[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<EnumeratedMultiProperty>(Enumeration[].class){

        public EnumeratedMultiProperty createWith(Map<String, String> valuesById) {
            return new EnumeratedMultiProperty<Object>(this.nameIn(valuesById), this.descriptionIn(valuesById), 1.labelsIn(valuesById), 1.choicesIn(valuesById), 1.indiciesIn(valuesById), 0.0f);
        }
    };

    public EnumeratedMultiProperty(String theName, String theDescription, String[] theLabels, E[] theChoices, int[] choiceIndices, float theUIOrder) {
        super(theName, theDescription, theLabels, theChoices, choiceIndices, theUIOrder, true);
    }

    @Override
    public Class<Object[]> type() {
        return Object[].class;
    }

    @Override
    public boolean isMultiValue() {
        return true;
    }

    @Override
    public String errorFor(Object value) {
        Object[] values = (Object[])value;
        for (int i = 0; i < values.length; ++i) {
            if (this.labelsByChoice.containsKey(values[i])) continue;
            return this.nonLegalValueMsgFor(values[i]);
        }
        return null;
    }

    @Override
    public Object[] valueFrom(String value) throws IllegalArgumentException {
        String[] strValues = StringUtil.substringsOf(value, this.multiValueDelimiter());
        Object[] values = new Object[strValues.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.choiceFrom(strValues[i]);
        }
        return values;
    }

    @Override
    public String asDelimitedString(Object[] value) {
        Object[] choices = value;
        StringBuilder sb = new StringBuilder();
        sb.append((String)this.labelsByChoice.get(choices[0]));
        for (int i = 1; i < choices.length; ++i) {
            sb.append(this.multiValueDelimiter());
            sb.append((String)this.labelsByChoice.get(choices[i]));
        }
        return sb.toString();
    }
}

