/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractNumericProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

public class IntegerProperty
extends AbstractNumericProperty<Integer> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<IntegerProperty>(Integer.class, numberFieldTypesByKey){

        public IntegerProperty createWith(Map<String, String> valuesById) {
            String[] minMax = 1.minMaxFrom(valuesById);
            return new IntegerProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), Integer.valueOf(minMax[0]), Integer.valueOf(minMax[1]), Integer.valueOf(this.numericDefaultValueIn(valuesById)), 0.0f);
        }
    };

    public IntegerProperty(String theName, String theDescription, Integer min, Integer max, Integer theDefault, float theUIOrder) {
        super(theName, theDescription, min, max, theDefault, theUIOrder);
    }

    public IntegerProperty(String theName, String theDescription, String minStr, String maxStr, String defaultStr, float theUIOrder) {
        this(theName, theDescription, IntegerProperty.intFrom(minStr), IntegerProperty.intFrom(maxStr), IntegerProperty.intFrom(defaultStr), theUIOrder);
    }

    public static Integer intFrom(String numberString) {
        return Integer.valueOf(numberString);
    }

    @Override
    public Class<Integer> type() {
        return Integer.class;
    }

    @Override
    protected Object createFrom(String value) {
        return IntegerProperty.intFrom(value);
    }
}

