/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractMultiNumericProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

public class LongMultiProperty
extends AbstractMultiNumericProperty<Long[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<LongMultiProperty>(Long[].class, numberFieldTypesByKey){

        public LongMultiProperty createWith(Map<String, String> valuesById) {
            String[] minMax = 1.minMaxFrom(valuesById);
            Long[] defaultValues = 1.longsIn(this.defaultValueIn(valuesById));
            return new LongMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), Long.parseLong(minMax[0]), Long.parseLong(minMax[1]), defaultValues, 0.0f);
        }
    };

    public LongMultiProperty(String theName, String theDescription, Long min, Long max, Long[] theDefaults, float theUIOrder) {
        super(theName, theDescription, min, max, theDefaults, theUIOrder);
    }

    @Override
    public Class<Long[]> type() {
        return Long[].class;
    }

    @Override
    protected Object createFrom(String value) {
        return Long.valueOf(value);
    }

    @Override
    protected Object[] arrayFor(int size) {
        return new Long[size];
    }
}

