/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.symboltable;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public abstract class AbstractScope
implements Scope {
    private Scope parent;
    private Map<NameDeclaration, List<NameOccurrence>> nameDeclarations = new LinkedHashMap<NameDeclaration, List<NameOccurrence>>();

    @Override
    public Scope getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Scope parent) {
        this.parent = parent;
    }

    @Override
    public Map<NameDeclaration, List<NameOccurrence>> getDeclarations() {
        return this.nameDeclarations;
    }

    @Override
    public <T extends NameDeclaration> Map<T, List<NameOccurrence>> getDeclarations(Class<T> clazz) {
        LinkedHashMap<NameDeclaration, List<NameOccurrence>> result = new LinkedHashMap<NameDeclaration, List<NameOccurrence>>();
        for (Map.Entry<NameDeclaration, List<NameOccurrence>> e : this.nameDeclarations.entrySet()) {
            if (!clazz.isAssignableFrom(e.getKey().getClass())) continue;
            NameDeclaration cast = e.getKey();
            result.put(cast, e.getValue());
        }
        return result;
    }

    @Override
    public boolean contains(NameOccurrence occ) {
        for (NameDeclaration d : this.nameDeclarations.keySet()) {
            if (!d.getImage().equals(occ.getImage())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addDeclaration(NameDeclaration declaration) {
        this.nameDeclarations.put(declaration, new ArrayList());
    }

    @Override
    public <T extends Scope> T getEnclosingScope(Class<T> clazz) {
        AbstractScope result = null;
        for (Scope current = this; result == null && current != null; current = current.getParent()) {
            AbstractScope cast;
            if (!clazz.isAssignableFrom(current.getClass())) continue;
            result = cast = current;
        }
        return (T)result;
    }

    @Override
    public NameDeclaration addNameOccurrence(NameOccurrence occurrence) {
        NameDeclaration result = null;
        for (Map.Entry<NameDeclaration, List<NameOccurrence>> e : this.nameDeclarations.entrySet()) {
            if (!e.getKey().getImage().equals(occurrence.getImage())) continue;
            result = e.getKey();
            e.getValue().add(occurrence);
        }
        return result;
    }
}

