/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import net.sourceforge.pmd.util.StringUtil;

public class IOUtil {
    private IOUtil() {
    }

    public static Writer createWriter() {
        return new OutputStreamWriter(System.out);
    }

    public static Writer createWriter(String reportFile) {
        try {
            return StringUtil.isEmpty(reportFile) ? IOUtil.createWriter() : new BufferedWriter(new FileWriter(reportFile));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Reader skipBOM(Reader source) {
        BufferedReader in = new BufferedReader(source);
        try {
            ((Reader)in).mark(1);
            int firstCharacter = ((Reader)in).read();
            if (firstCharacter != 65279) {
                ((Reader)in).reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while trying to skip BOM marker", e);
        }
        return in;
    }
}

