/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBType {
    private static final String CLASS_NAME = DBType.class.getCanonicalName();
    private static final Logger LOGGER = Logger.getLogger(DBType.class.getPackage().getName());
    private static final String INTERNAL_SETTINGS = "[Internal Settings]";
    private String propertiesSource;
    private Properties properties;
    private String driverClass;
    private String characterSet;
    private String sourceCodeTypes;
    private String languages;
    private int sourceCodeReturnType;

    public DBType(String dbType) throws Exception {
        this.properties = this.loadDBProperties(dbType);
    }

    public DBType(String subProtocol, String subnamePrefix) throws IOException {
        LOGGER.fine("subProtocol=" + subProtocol + ", subnamePrefix=" + subnamePrefix);
        if (null == subProtocol && null == subnamePrefix) {
            throw new RuntimeException("subProtocol and subnamePrefix cannot both be null");
        }
        this.properties = null;
        if (null != subnamePrefix && null != (this.properties = this.loadDBProperties(subnamePrefix))) {
            LOGGER.log(Level.FINE, "DBType found using subnamePrefix={0}", subnamePrefix);
        } else {
            this.properties = this.loadDBProperties(subProtocol);
            if (null != this.properties) {
                LOGGER.log(Level.FINE, "DBType found using subProtocol={0}", subProtocol);
            } else {
                throw new RuntimeException(String.format("Could not locate DBType properties using subProtocol=%s and subnamePrefix=%s", subProtocol, subnamePrefix));
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Properties loadDBProperties(String matchString) throws IOException {
        LOGGER.entering(CLASS_NAME, matchString);
        ResourceBundle resourceBundle = null;
        LOGGER.finest("class_path+" + System.getProperty("java.class.path"));
        try {
            File propertiesFile = new File(matchString);
            LOGGER.finest("Attempting File no file suffix: " + matchString);
            resourceBundle = new PropertyResourceBundle(new FileInputStream(propertiesFile));
            this.propertiesSource = propertiesFile.getAbsolutePath();
            LOGGER.finest("FileSystemWithoutExtension");
        }
        catch (FileNotFoundException notFoundOnFilesystemWithoutExtension) {
            LOGGER.finest("notFoundOnFilesystemWithoutExtension");
            LOGGER.finest("Attempting File with added file suffix: " + matchString + ".properties");
            try {
                File propertiesFile = new File(matchString + ".properties");
                resourceBundle = new PropertyResourceBundle(new FileInputStream(propertiesFile));
                this.propertiesSource = propertiesFile.getAbsolutePath();
                LOGGER.finest("FileSystemWithExtension");
            }
            catch (FileNotFoundException notFoundOnFilesystemWithExtensionTackedOn) {
                LOGGER.finest("Attempting JARWithoutClassPrefix: " + matchString);
                try {
                    resourceBundle = ResourceBundle.getBundle(matchString);
                    this.propertiesSource = "[[Internal Settings]]" + File.separator + matchString + ".properties";
                    LOGGER.finest("InJarWithoutPath");
                }
                catch (Exception notInJarWithoutPath) {
                    LOGGER.finest("Attempting JARWithClass prefix: " + CLASS_NAME + "." + matchString);
                    try {
                        resourceBundle = ResourceBundle.getBundle(CLASS_NAME + "." + matchString);
                        this.propertiesSource = "[[Internal Settings]]" + File.separator + matchString + ".properties";
                        LOGGER.finest("found InJarWithPath");
                    }
                    catch (Exception notInJarWithPath) {
                        notInJarWithPath.printStackTrace();
                        notFoundOnFilesystemWithExtensionTackedOn.printStackTrace();
                        throw new RuntimeException(" Could not locate DBTYpe settings : " + matchString, notInJarWithPath);
                    }
                }
            }
        }
        Properties matchedProperties = DBType.getResourceBundleAsProperties(resourceBundle);
        resourceBundle = null;
        String saveLoadedFrom = this.getPropertiesSource();
        String extendedPropertyFile = (String)matchedProperties.remove("extends");
        if (null != extendedPropertyFile && !"".equals(extendedPropertyFile.trim())) {
            Properties extendedProperties = this.loadDBProperties(extendedPropertyFile.trim());
            extendedProperties.putAll((Map<?, ?>)matchedProperties);
            matchedProperties = extendedProperties;
        }
        this.propertiesSource = saveLoadedFrom;
        this.setProperties(matchedProperties);
        return matchedProperties;
    }

    public static Properties getResourceBundleAsProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        for (String key : resourceBundle.keySet()) {
            properties.put(key, resourceBundle.getObject(key));
        }
        return properties;
    }

    public boolean equals(DBType other) {
        return this.getPropertiesSource().equals(other.getPropertiesSource()) && this.getProperties().equals(other.getProperties()) && this.getDriverClass().equals(other.getDriverClass()) && this.getCharacterSet().equals(other.getCharacterSet()) && this.getSourceCodeTypes().equals(other.getSourceCodeTypes()) && this.getLanguages().equals(other.getLanguages()) && this.getSourceCodeReturnType() == other.getSourceCodeReturnType();
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getSourceCodeTypes() {
        return this.sourceCodeTypes;
    }

    public String getLanguages() {
        return this.languages;
    }

    public int getSourceCodeReturnType() {
        return this.sourceCodeReturnType;
    }

    public String getPropertiesSource() {
        return this.propertiesSource;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        if (null != this.properties.getProperty("driver")) {
            this.driverClass = this.properties.getProperty("driver");
        }
        if (null != this.properties.getProperty("characterset")) {
            this.characterSet = this.properties.getProperty("characterset");
        }
        if (null != this.properties.getProperty("sourcecodetypes")) {
            this.sourceCodeTypes = this.properties.getProperty("sourcecodetypes");
        }
        if (null != this.properties.getProperty("languages")) {
            this.languages = this.properties.getProperty("languages");
        }
        if (null != this.properties.getProperty("returnType")) {
            LOGGER.finest("returnType" + this.properties.getProperty("returnType"));
            this.sourceCodeReturnType = Integer.parseInt(this.properties.getProperty("returnType"));
        }
    }

    public String toString() {
        return CLASS_NAME + "@" + this.propertiesSource;
    }

    public static enum property {
        USER("user", "Name of the connecting database user"),
        PASSWORD("password", "The connecting database user's password"),
        DRIVER("driver", "JDBC driver classname"),
        CHARACTERSET("characterset", "Reader character set"),
        LANGUAGES("languages", "Comma-separated list of PMD-supported languages"),
        SCHEMAS("schemas", "SchemaSpy compatible regular expression for schemas to be processed"),
        SOURCE_TYPES("sourcecodetypes", "Comma-separated list of supported source types"),
        SOURCE_NAMES("sourcecodenames", "Default comma-separated list of source code names to validate"),
        GET_SOURCE_CODE_STATEMENT("getSourceCodeStatement", "SQL92 or Oracle embedded SQL statement to retrieve  code source from the database catalogue"),
        RETURN_TYPE("returnType", "int equivalent of java.sql.Types return type of getSourceCodeStatement");

        private String name;

        private property(String name, String description) {
            this.name = name;
        }
    }
}

