/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.support.ServletConfigPropertySource;
import org.springframework.web.context.support.ServletContextPropertySource;
import org.springframework.web.context.support.ServletContextScope;

public abstract class WebApplicationContextUtils {
    private static final boolean jsfPresent = ClassUtils.isPresent((String)"javax.faces.context.FacesContext", (ClassLoader)RequestContextHolder.class.getClassLoader());

    public static WebApplicationContext getRequiredWebApplicationContext(ServletContext sc) throws IllegalStateException {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(sc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    public static WebApplicationContext getWebApplicationContext(ServletContext sc) {
        return WebApplicationContextUtils.getWebApplicationContext(sc, WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public static WebApplicationContext getWebApplicationContext(ServletContext sc, String attrName) {
        Assert.notNull((Object)sc, (String)"ServletContext must not be null");
        Object attr = sc.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (attr instanceof Exception) {
            throw new IllegalStateException((Exception)attr);
        }
        if (!(attr instanceof WebApplicationContext)) {
            throw new IllegalStateException("Context attribute is not of type WebApplicationContext: " + attr);
        }
        return (WebApplicationContext)attr;
    }

    public static void registerWebApplicationScopes(ConfigurableListableBeanFactory beanFactory) {
        WebApplicationContextUtils.registerWebApplicationScopes(beanFactory, null);
    }

    public static void registerWebApplicationScopes(ConfigurableListableBeanFactory beanFactory, ServletContext sc) {
        beanFactory.registerScope("request", (Scope)new RequestScope());
        beanFactory.registerScope("session", (Scope)new SessionScope(false));
        beanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        if (sc != null) {
            ServletContextScope appScope = new ServletContextScope(sc);
            beanFactory.registerScope("application", (Scope)appScope);
            sc.setAttribute(ServletContextScope.class.getName(), (Object)appScope);
        }
        beanFactory.registerResolvableDependency(ServletRequest.class, (Object)new RequestObjectFactory());
        beanFactory.registerResolvableDependency(HttpSession.class, (Object)new SessionObjectFactory());
        beanFactory.registerResolvableDependency(WebRequest.class, (Object)new WebRequestObjectFactory());
        if (jsfPresent) {
            FacesDependencyRegistrar.registerFacesDependencies(beanFactory);
        }
    }

    public static void registerEnvironmentBeans(ConfigurableListableBeanFactory bf, ServletContext sc) {
        WebApplicationContextUtils.registerEnvironmentBeans(bf, sc, null);
    }

    public static void registerEnvironmentBeans(ConfigurableListableBeanFactory bf, ServletContext servletContext, ServletConfig servletConfig) {
        if (servletContext != null && !bf.containsBean("servletContext")) {
            bf.registerSingleton("servletContext", (Object)servletContext);
        }
        if (servletConfig != null && !bf.containsBean("servletConfig")) {
            bf.registerSingleton("servletConfig", (Object)servletConfig);
        }
        if (!bf.containsBean("contextParameters")) {
            String paramName;
            Enumeration paramNameEnum;
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            if (servletContext != null) {
                paramNameEnum = servletContext.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, servletContext.getInitParameter(paramName));
                }
            }
            if (servletConfig != null) {
                paramNameEnum = servletConfig.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, servletConfig.getInitParameter(paramName));
                }
            }
            bf.registerSingleton("contextParameters", Collections.unmodifiableMap(parameterMap));
        }
        if (!bf.containsBean("contextAttributes")) {
            HashMap<String, Object> attributeMap = new HashMap<String, Object>();
            if (servletContext != null) {
                Enumeration attrNameEnum = servletContext.getAttributeNames();
                while (attrNameEnum.hasMoreElements()) {
                    String attrName = (String)attrNameEnum.nextElement();
                    attributeMap.put(attrName, servletContext.getAttribute(attrName));
                }
            }
            bf.registerSingleton("contextAttributes", Collections.unmodifiableMap(attributeMap));
        }
    }

    public static void initServletPropertySources(MutablePropertySources propertySources, ServletContext servletContext) {
        WebApplicationContextUtils.initServletPropertySources(propertySources, servletContext, null);
    }

    public static void initServletPropertySources(MutablePropertySources propertySources, ServletContext servletContext, ServletConfig servletConfig) {
        Assert.notNull((Object)propertySources, (String)"propertySources must not be null");
        if (servletContext != null && propertySources.contains("servletContextInitParams") && propertySources.get("servletContextInitParams") instanceof PropertySource.StubPropertySource) {
            propertySources.replace("servletContextInitParams", (PropertySource)new ServletContextPropertySource("servletContextInitParams", servletContext));
        }
        if (servletConfig != null && propertySources.contains("servletConfigInitParams") && propertySources.get("servletConfigInitParams") instanceof PropertySource.StubPropertySource) {
            propertySources.replace("servletConfigInitParams", (PropertySource)new ServletConfigPropertySource("servletConfigInitParams", servletConfig));
        }
    }

    private static ServletRequestAttributes currentRequestAttributes() {
        RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
        if (!(requestAttr instanceof ServletRequestAttributes)) {
            throw new IllegalStateException("Current request is not a servlet request");
        }
        return (ServletRequestAttributes)requestAttr;
    }

    private static class FacesDependencyRegistrar {
        private FacesDependencyRegistrar() {
        }

        public static void registerFacesDependencies(ConfigurableListableBeanFactory beanFactory) {
            beanFactory.registerResolvableDependency(FacesContext.class, (Object)new ObjectFactory<FacesContext>(){

                public FacesContext getObject() {
                    return FacesContext.getCurrentInstance();
                }

                public String toString() {
                    return "Current JSF FacesContext";
                }
            });
            beanFactory.registerResolvableDependency(ExternalContext.class, (Object)new ObjectFactory<ExternalContext>(){

                public ExternalContext getObject() {
                    return FacesContext.getCurrentInstance().getExternalContext();
                }

                public String toString() {
                    return "Current JSF ExternalContext";
                }
            });
        }
    }

    private static class WebRequestObjectFactory
    implements ObjectFactory<WebRequest>,
    Serializable {
        private WebRequestObjectFactory() {
        }

        public WebRequest getObject() {
            return new ServletWebRequest(WebApplicationContextUtils.currentRequestAttributes().getRequest());
        }

        public String toString() {
            return "Current ServletWebRequest";
        }
    }

    private static class SessionObjectFactory
    implements ObjectFactory<HttpSession>,
    Serializable {
        private SessionObjectFactory() {
        }

        public HttpSession getObject() {
            return WebApplicationContextUtils.currentRequestAttributes().getRequest().getSession();
        }

        public String toString() {
            return "Current HttpSession";
        }
    }

    private static class RequestObjectFactory
    implements ObjectFactory<ServletRequest>,
    Serializable {
        private RequestObjectFactory() {
        }

        public ServletRequest getObject() {
            return WebApplicationContextUtils.currentRequestAttributes().getRequest();
        }

        public String toString() {
            return "Current HttpServletRequest";
        }
    }
}

