/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class TbLobOutputStream
extends OutputStream {
    private TbLob lob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private boolean opened = false;
    private boolean isBlob = false;
    private byte[] byteBuf = null;
    private char[] charBuf = null;

    public TbLobOutputStream(TbLob tbLob, long l) throws SQLException {
        Debug.logMethod("TbLobOutputStream", new Object[]{this, tbLob, Long.toString(l)});
        if (tbLob == null) {
            throw TbError.newSQLException(-590767);
        }
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        this.lob = tbLob;
        this.lobOffset = l - 1L;
        this.bufOffset = 0;
        this.opened = true;
        if (tbLob instanceof TbClobBase) {
            this.charBuf = new char[TbLob.getMaxChunkSize()];
            this.isBlob = false;
        } else if (tbLob instanceof TbBlob) {
            this.byteBuf = new byte[TbLob.getMaxChunkSize()];
            this.isBlob = true;
        } else {
            throw TbError.newSQLException(-590770, tbLob.toString());
        }
    }

    private void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    public void close() throws IOException {
        Debug.logMethod("TbLobOutputStream.close", new Object[]{this, this.lob});
        try {
            this.flushBuffer();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        this.opened = false;
    }

    public void flush() throws IOException {
        Debug.logMethod("TbLobOutputStream.flush", new Object[]{this, this.lob});
        try {
            this.flushBuffer();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    private void flushBuffer() throws SQLException {
        int n = 0;
        n = this.isBlob ? ((TbBlob)this.lob).setBytes(this.lobOffset + 1L, this.byteBuf, 0, this.bufOffset) : ((TbClob)this.lob).putChars(this.lobOffset + 1L, this.charBuf, 0L, this.bufOffset);
        this.lobOffset += (long)n;
        this.bufOffset = 0;
    }

    private int getRemainedInBuffer() {
        return TbLob.getMaxChunkSize() - this.bufOffset;
    }

    public void write(int n) throws IOException {
        Debug.logMethod("TbLobOutputStream.write", new Object[]{this, this.lob, Integer.toString(n)});
        this.checkClosed();
        if (this.getRemainedInBuffer() == 0) {
            try {
                this.flushBuffer();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
        if (this.isBlob) {
            this.byteBuf[this.bufOffset++] = (byte)n;
        } else {
            this.charBuf[this.bufOffset++] = (char)n;
        }
    }
}

