/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.msg.TbOutParamUdt;
import java.sql.SQLException;

public class BindItem {
    private int paramMode = 0;
    private int sqlType = 0;
    private int length;
    private TbColumnDesc[] colMeta;
    private TbOutParamUdt[] subParams;
    private String typeName;

    public void clone(BindItem bindItem) {
        bindItem.paramMode = this.paramMode;
        bindItem.sqlType = this.sqlType;
        bindItem.length = this.length;
        bindItem.typeName = this.typeName;
    }

    public TbColumnDesc[] getColMeta() {
        return this.colMeta;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public int getLength() {
        return this.length;
    }

    public int getParamMode() {
        return this.paramMode;
    }

    public boolean isDFRParameter() {
        return this.paramMode == 8;
    }

    public boolean isINOUTParameter() {
        return this.paramMode == 4;
    }

    public boolean isINParameter() {
        return this.paramMode == 1 || this.paramMode == 4;
    }

    public boolean isOUTParameter() {
        return this.paramMode == 2 || this.paramMode == 4;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public TbOutParamUdt[] getSubParams() {
        return this.subParams;
    }

    public void reset() {
        int n;
        if (this.colMeta != null) {
            for (n = 0; n < this.colMeta.length; ++n) {
                this.colMeta[n] = null;
            }
            this.colMeta = null;
        }
        if (this.subParams != null) {
            for (n = 0; n < this.subParams.length; ++n) {
                this.subParams[n] = null;
            }
            this.subParams = null;
        }
    }

    public void reuse() {
        int n;
        this.paramMode = 0;
        this.sqlType = 0;
        this.typeName = null;
        if (this.colMeta != null) {
            for (n = 0; n < this.colMeta.length; ++n) {
                this.colMeta[n] = null;
            }
            this.colMeta = null;
        }
        if (this.subParams != null) {
            for (n = 0; n < this.subParams.length; ++n) {
                this.subParams[n] = null;
            }
            this.subParams = null;
        }
    }

    public void set(int n, int n2) {
        this.setParamMode(n);
        this.sqlType = n2;
    }

    public void set(int n, int n2, int n3) throws SQLException {
        this.setParamMode(n);
        this.sqlType = n2;
        this.length = n3;
    }

    public void set(int n, int n2, TbColumnDesc[] tbColumnDescArray, TbOutParamUdt[] tbOutParamUdtArray) throws SQLException {
        this.paramMode = 2;
        this.sqlType = n;
        this.length = n2;
        this.colMeta = tbColumnDescArray;
        this.subParams = tbOutParamUdtArray;
    }

    public void set(int n, int n2, TbColumnDesc[] tbColumnDescArray, TbOutParamUdt[] tbOutParamUdtArray, String string) throws SQLException {
        this.paramMode = 2;
        this.sqlType = n;
        this.length = n2;
        this.colMeta = tbColumnDescArray;
        this.subParams = tbOutParamUdtArray;
        this.typeName = string;
    }

    private void setParamMode(int n) {
        this.paramMode = this.paramMode == 1 && n == 2 || this.paramMode == 2 && n == 1 ? 4 : n;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(96);
        stringBuffer.append(super.toString()).append("[mode=").append(this.paramMode).append("/sqlType=").append(this.sqlType).append("/length=").append(this.length).append("/colMeta=").append(this.colMeta).append("/subParams=").append(this.subParams).append("/typeName=").append(this.typeName).append(']');
        return stringBuffer.toString();
    }
}

