/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.ASCIIDecoder;
import com.tmax.tibero.jdbc.data.charset.ASCIIEncoder;
import com.tmax.tibero.jdbc.data.charset.CP866Decoder;
import com.tmax.tibero.jdbc.data.charset.CP866Encoder;
import com.tmax.tibero.jdbc.data.charset.Charset;
import com.tmax.tibero.jdbc.data.charset.CharsetDecoder;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.EUCCNDecoder;
import com.tmax.tibero.jdbc.data.charset.EUCCNEncoder;
import com.tmax.tibero.jdbc.data.charset.EUCJPDecoder;
import com.tmax.tibero.jdbc.data.charset.EUCJPEncoder;
import com.tmax.tibero.jdbc.data.charset.EUCJPTILDEDecoder;
import com.tmax.tibero.jdbc.data.charset.EUCJPTILDEEncoder;
import com.tmax.tibero.jdbc.data.charset.EUCKRDecoder;
import com.tmax.tibero.jdbc.data.charset.EUCKREncoder;
import com.tmax.tibero.jdbc.data.charset.GBKDecoder;
import com.tmax.tibero.jdbc.data.charset.GBKEncoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P15Decoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P15Encoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P1Decoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P1Encoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P2Decoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P2Encoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P5Decoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P5Encoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P9Decoder;
import com.tmax.tibero.jdbc.data.charset.ISO8859P9Encoder;
import com.tmax.tibero.jdbc.data.charset.JA16SJISDecoder;
import com.tmax.tibero.jdbc.data.charset.JA16SJISEncoder;
import com.tmax.tibero.jdbc.data.charset.JA16SJISTILDEDecoder;
import com.tmax.tibero.jdbc.data.charset.JA16SJISTILDEEncoder;
import com.tmax.tibero.jdbc.data.charset.KOI8RDecoder;
import com.tmax.tibero.jdbc.data.charset.KOI8REncoder;
import com.tmax.tibero.jdbc.data.charset.MS1251Decoder;
import com.tmax.tibero.jdbc.data.charset.MS1251Encoder;
import com.tmax.tibero.jdbc.data.charset.MS1252Decoder;
import com.tmax.tibero.jdbc.data.charset.MS1252Encoder;
import com.tmax.tibero.jdbc.data.charset.MS949Decoder;
import com.tmax.tibero.jdbc.data.charset.MS949Encoder;
import com.tmax.tibero.jdbc.data.charset.MS950Decoder;
import com.tmax.tibero.jdbc.data.charset.MS950Encoder;
import com.tmax.tibero.jdbc.data.charset.SJISDecoder;
import com.tmax.tibero.jdbc.data.charset.SJISEncoder;
import com.tmax.tibero.jdbc.data.charset.TCVN3Decoder;
import com.tmax.tibero.jdbc.data.charset.TCVN3Encoder;
import com.tmax.tibero.jdbc.data.charset.TIS620Decoder;
import com.tmax.tibero.jdbc.data.charset.TIS620Encoder;
import com.tmax.tibero.jdbc.data.charset.UTF16Decoder;
import com.tmax.tibero.jdbc.data.charset.UTF16Encoder;
import com.tmax.tibero.jdbc.data.charset.UTF8Decoder;
import com.tmax.tibero.jdbc.data.charset.UTF8Encoder;
import java.sql.SQLException;

public class CharsetMapper {
    private CharsetEncoder encoder = null;
    private CharsetDecoder decoder = null;

    public CharsetMapper(int n) {
        switch (n) {
            case 0: {
                this.encoder = new ASCIIEncoder();
                this.decoder = new ASCIIDecoder();
                break;
            }
            case 1: {
                this.encoder = new EUCKREncoder();
                this.decoder = new EUCKRDecoder();
                break;
            }
            case 2: {
                this.encoder = new MS949Encoder();
                this.decoder = new MS949Decoder();
                break;
            }
            case 3: {
                this.encoder = new UTF8Encoder();
                this.decoder = new UTF8Decoder();
                break;
            }
            case 4: {
                this.encoder = new UTF16Encoder();
                this.decoder = new UTF16Decoder();
                break;
            }
            case 5: {
                this.encoder = new SJISEncoder();
                this.decoder = new SJISDecoder();
                break;
            }
            case 6: {
                this.encoder = new JA16SJISEncoder();
                this.decoder = new JA16SJISDecoder();
                break;
            }
            case 7: {
                this.encoder = new JA16SJISTILDEEncoder();
                this.decoder = new JA16SJISTILDEDecoder();
                break;
            }
            case 8: {
                this.encoder = new EUCJPEncoder();
                this.decoder = new EUCJPDecoder();
                break;
            }
            case 9: {
                this.encoder = new EUCJPTILDEEncoder();
                this.decoder = new EUCJPTILDEDecoder();
                break;
            }
            case 10: {
                this.encoder = new TCVN3Encoder();
                this.decoder = new TCVN3Decoder();
                break;
            }
            case 11: {
                this.encoder = new GBKEncoder();
                this.decoder = new GBKDecoder();
                break;
            }
            case 12: {
                this.encoder = new MS1252Encoder();
                this.decoder = new MS1252Decoder();
                break;
            }
            case 13: {
                this.encoder = new MS950Encoder();
                this.decoder = new MS950Decoder();
                break;
            }
            case 14: {
                this.encoder = new MS1251Encoder();
                this.decoder = new MS1251Decoder();
                break;
            }
            case 15: {
                this.encoder = new ISO8859P1Encoder();
                this.decoder = new ISO8859P1Decoder();
                break;
            }
            case 16: {
                this.encoder = new ISO8859P2Encoder();
                this.decoder = new ISO8859P2Decoder();
                break;
            }
            case 17: {
                this.encoder = new ISO8859P9Encoder();
                this.decoder = new ISO8859P9Decoder();
                break;
            }
            case 18: {
                this.encoder = new ISO8859P15Encoder();
                this.decoder = new ISO8859P15Decoder();
                break;
            }
            case 19: {
                this.encoder = new KOI8REncoder();
                this.decoder = new KOI8RDecoder();
                break;
            }
            case 20: {
                this.encoder = new ISO8859P5Encoder();
                this.decoder = new ISO8859P5Decoder();
                break;
            }
            case 21: {
                this.encoder = new CP866Encoder();
                this.decoder = new CP866Decoder();
                break;
            }
            case 22: {
                this.encoder = new TIS620Encoder();
                this.decoder = new TIS620Decoder();
            }
        }
    }

    public CharsetMapper(String string) {
        if (string.equalsIgnoreCase("EUC-KR")) {
            this.encoder = new EUCKREncoder();
            this.decoder = new EUCKRDecoder();
        } else if (string.equalsIgnoreCase("MSWIN949")) {
            this.encoder = new MS949Encoder();
            this.decoder = new MS949Decoder();
        } else if (string.equalsIgnoreCase("UTF-8")) {
            this.encoder = new UTF8Encoder();
            this.decoder = new UTF8Decoder();
        } else if (string.equalsIgnoreCase("ASCII")) {
            this.encoder = new ASCIIEncoder();
            this.decoder = new ASCIIDecoder();
        } else if (string.equalsIgnoreCase("UTF-16")) {
            this.encoder = new UTF16Encoder();
            this.decoder = new UTF16Decoder();
        } else if (string.equalsIgnoreCase("SHIFT-JIS")) {
            this.encoder = new SJISEncoder();
            this.decoder = new SJISDecoder();
        } else if (string.equalsIgnoreCase("JA16SJIS")) {
            this.encoder = new JA16SJISEncoder();
            this.decoder = new JA16SJISDecoder();
        } else if (string.equalsIgnoreCase("JA16SJISTILDE")) {
            this.encoder = new JA16SJISTILDEEncoder();
            this.decoder = new JA16SJISTILDEDecoder();
        } else if (string.equalsIgnoreCase("JA16EUC")) {
            this.encoder = new EUCJPEncoder();
            this.decoder = new EUCJPDecoder();
        } else if (string.equalsIgnoreCase("JA16EUCTILDE")) {
            this.encoder = new EUCJPTILDEEncoder();
            this.decoder = new EUCJPTILDEDecoder();
        } else if (string.equalsIgnoreCase("EUC-CN")) {
            this.encoder = new EUCCNEncoder();
            this.decoder = new EUCCNDecoder();
        } else if (string.equalsIgnoreCase("VN8VN3")) {
            this.encoder = new TCVN3Encoder();
            this.decoder = new TCVN3Decoder();
        } else if (string.equalsIgnoreCase("GBK")) {
            this.encoder = new GBKEncoder();
            this.decoder = new GBKDecoder();
        } else if (string.equalsIgnoreCase("WE8MSWIN1252") || string.equalsIgnoreCase("MSWIN1252")) {
            this.encoder = new MS1252Encoder();
            this.decoder = new MS1252Decoder();
        } else if (string.equalsIgnoreCase("ZHT16HKSCS") || string.equalsIgnoreCase("MSWIN950")) {
            this.encoder = new MS950Encoder();
            this.decoder = new MS950Decoder();
        } else if (string.equalsIgnoreCase("CL8MSWIN1251") || string.equalsIgnoreCase("MSWIN1251")) {
            this.encoder = new MS1251Encoder();
            this.decoder = new MS1251Decoder();
        } else if (string.equalsIgnoreCase("WE8ISO8859P1") || string.equalsIgnoreCase("ISO8859P1")) {
            this.encoder = new ISO8859P1Encoder();
            this.decoder = new ISO8859P1Decoder();
        } else if (string.equalsIgnoreCase("EE8ISO8859P2") || string.equalsIgnoreCase("ISO8859P2")) {
            this.encoder = new ISO8859P2Encoder();
            this.decoder = new ISO8859P2Decoder();
        } else if (string.equalsIgnoreCase("WE8ISO8859P9") || string.equalsIgnoreCase("ISO8859P9")) {
            this.encoder = new ISO8859P9Encoder();
            this.decoder = new ISO8859P9Decoder();
        } else if (string.equalsIgnoreCase("WE8ISO8859P15") || string.equalsIgnoreCase("ISO8859P15")) {
            this.encoder = new ISO8859P15Encoder();
            this.decoder = new ISO8859P15Decoder();
        } else if (string.equalsIgnoreCase("CL8KOI8R") || string.equalsIgnoreCase("KOI8-R")) {
            this.encoder = new KOI8REncoder();
            this.decoder = new KOI8RDecoder();
        } else if (string.equalsIgnoreCase("CL8ISO8859P5") || string.equalsIgnoreCase("ISO8859P5")) {
            this.encoder = new ISO8859P5Encoder();
            this.decoder = new ISO8859P5Decoder();
        } else if (string.equalsIgnoreCase("RU8PC866") || string.equalsIgnoreCase("CP866") || string.equalsIgnoreCase("MSDOS866")) {
            this.encoder = new CP866Encoder();
            this.decoder = new CP866Decoder();
        } else if (string.equalsIgnoreCase(Charset.name[22]) || string.equalsIgnoreCase(Charset.alias[22])) {
            this.encoder = new TIS620Encoder();
            this.decoder = new TIS620Decoder();
        }
    }

    public int bytesToChars(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4, boolean bl) throws SQLException {
        if (bl) {
            return this.decoder.fixedBytesToChars(byArray, n, n2, cArray, n3, n4);
        }
        return this.decoder.bytesToChars(byArray, n, n2, cArray, n3, n4);
    }

    public String bytesToString(byte[] byArray, int n, int n2, boolean bl) throws SQLException {
        if (bl) {
            return this.decoder.fixedBytesToString(byArray, n, n2);
        }
        return this.decoder.bytesToString(byArray, n, n2);
    }

    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4, boolean bl) throws SQLException {
        if (bl) {
            return this.encoder.charsToFixedBytes(cArray, n, n2, byArray, n3, n4);
        }
        return this.encoder.charsToBytes(cArray, n, n2, byArray, n3, n4);
    }

    public int getEndingBytePos(byte[] byArray, int n) {
        return this.encoder.getEndingBytePos(byArray, n);
    }

    public int getLeadingBytePos(byte[] byArray, int n) {
        return this.encoder.getLeadingBytePos(byArray, n);
    }

    public int getMaxBytesPerChar() {
        return this.encoder.getMaxBytesPerChar();
    }

    public byte[] stringToBytes(String string) throws SQLException {
        return this.encoder.stringToBytes(string);
    }

    public int stringToBytes(byte[] byArray, int n, String string) throws SQLException {
        return this.encoder.stringToBytes(byArray, n, string);
    }
}

