/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.LinkedList;

public class TbRSScrollable
extends TbResultSetBase {
    protected AbstractList rows = new LinkedList();

    protected TbRSScrollable(TbStatement tbStatement, int n, int n2, int n3) throws SQLException {
        super(tbStatement, n, n2, n3);
        this.currentRowIndex = -1;
        Debug.logMethod("TbRSScrollable", new Object[]{this});
    }

    public synchronized boolean absolute(int n) throws SQLException {
        Debug.logMethod("TbRSScrollable.absolute", new Object[]{this, Integer.toString(n)});
        if (n == 0) {
            throw TbError.newSQLException(-590736);
        }
        if (this.isRSEmpty()) {
            return false;
        }
        if (n > 0) {
            this.currentRowIndex = n - 1;
        } else {
            if (!this.fetchComplete) {
                this.fetchRowsAll();
            }
            this.currentRowIndex = this.rowsFetchedCnt + n;
        }
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public synchronized void afterLast() throws SQLException {
        Debug.logMethod("TbRSScrollable.afterLast", new Object[]{this});
        if (!this.isRSEmpty()) {
            if (!this.fetchComplete) {
                this.fetchRowsAll();
            }
            this.currentRowIndex = this.stmt.getMaxRows() != 0 && this.currentRowIndex >= this.stmt.getMaxRows() ? this.stmt.getMaxRows() : this.rowsFetchedCnt;
        }
    }

    public synchronized void beforeFirst() throws SQLException {
        Debug.logMethod("TbRSScrollable.beforeFirst", new Object[]{this});
        if (!this.isRSEmpty()) {
            this.currentRowIndex = -1;
        }
    }

    public byte[] getRowChunk(int n) {
        this.rowChunk = new byte[n];
        return this.rowChunk;
    }

    public void buildRowTable(int n, byte[] byArray) throws SQLException {
        Row[] rowArray = new Row[n];
        int n2 = 1;
        if (this.rowsFetchedCnt + n < 0) {
            throw TbError.newSQLException(-90613);
        }
        this.currentFetchCount = n;
        this.rowsFetchedCnt += n;
        for (int i = 0; i < n; ++i) {
            rowArray[i] = new Row(this.columnCount);
            n2 += rowArray[i].buildRowData(byArray, n2, this.cols);
            this.rows.add(rowArray[i]);
        }
    }

    protected void checkRowIndex(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-90635);
        }
        if (this.stmt.getMaxRows() != 0 && n >= this.stmt.getMaxRows() || n >= this.rowsFetchedCnt) {
            throw TbError.newSQLException(-90624);
        }
    }

    protected void fetchRowsAll() throws SQLException {
        Debug.logMethod("TbRSScrollable.fetchRowsAll", new Object[]{this});
        while (this.stmt.getMaxRows() == 0 && this.currentRowIndex < this.stmt.getMaxRows() && !this.fetchComplete) {
            this.fetchRowsChunk();
        }
    }

    public synchronized boolean first() throws SQLException {
        Debug.logMethod("TbRSScrollable.first", new Object[]{this});
        if (this.isRSEmpty()) {
            return false;
        }
        this.currentRowIndex = 0;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    protected Row getCurrentRow() throws SQLException {
        if (this.currentRowIndex < 0) {
            throw TbError.newSQLException(-90635);
        }
        if (this.currentRowIndex >= this.rowsFetchedCnt) {
            throw TbError.newSQLException(-90624);
        }
        return (Row)this.rows.get(this.currentRowIndex);
    }

    protected Row getRowAt(int n) throws SQLException {
        return (Row)this.rows.get(n);
    }

    public synchronized boolean isLast() throws SQLException {
        Debug.logMethod("TbResultSetBase.isLast", new Object[]{this});
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex + 1 == this.stmt.getMaxRows()) {
            return true;
        }
        if (this.currentRowIndex + 1 == this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return true;
            }
            this.fetchRowsChunk();
            return this.fetchComplete && this.currentRowIndex + 1 == this.rowsFetchedCnt;
        }
        return false;
    }

    protected boolean isRSEmpty() throws SQLException {
        if (this.rowsFetchedCnt != 0) {
            return false;
        }
        if (this.rowsFetchedCnt == 0 && this.fetchComplete) {
            return true;
        }
        return !this.isValidRowIndex(0);
    }

    protected boolean isValidRowIndex(int n) throws SQLException {
        Debug.logMethod("TbRSScrollable.isValidRowIndex", new Object[]{this, Integer.toString(n)});
        if (this.stmt.getMaxRows() != 0 && n >= this.stmt.getMaxRows()) {
            return false;
        }
        if (n >= 0 && n < this.rowsFetchedCnt) {
            return true;
        }
        if (n < 0) {
            return false;
        }
        if (n >= this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return false;
            }
            while (n >= this.rowsFetchedCnt) {
                if (!this.fetchComplete) {
                    this.rowChunk = null;
                    this.fetchRowsChunk();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public synchronized boolean last() throws SQLException {
        Debug.logMethod("TbRSScrollable.last", new Object[]{this});
        if (this.isRSEmpty()) {
            return false;
        }
        if (!this.fetchComplete) {
            this.fetchRowsAll();
        }
        this.currentRowIndex = this.rowsFetchedCnt - 1;
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex >= this.stmt.getMaxRows()) {
            this.currentRowIndex = this.stmt.getMaxRows() - 1;
        }
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public synchronized boolean next() throws SQLException {
        Debug.logMethod("TbRSScrollable.next", new Object[]{Integer.toString(this.currentRowIndex)});
        this.currentRowIndex = this.currentRowIndex < 0 ? 0 : ++this.currentRowIndex;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public synchronized boolean previous() throws SQLException {
        Debug.logMethod("TbRSScrollable.previous", new Object[]{this});
        if (this.isRSEmpty()) {
            return false;
        }
        this.currentRowIndex = this.currentRowIndex > 0 && !this.isValidRowIndex(this.currentRowIndex) ? this.rowsFetchedCnt - 1 : --this.currentRowIndex;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    public synchronized boolean relative(int n) throws SQLException {
        Debug.logMethod("TbRSScrollable.relative", new Object[]{this, Integer.toString(n)});
        if (this.isRSEmpty()) {
            return false;
        }
        if (this.isValidRowIndex(this.currentRowIndex)) {
            this.currentRowIndex += n;
            return this.isValidRowIndex(this.currentRowIndex);
        }
        throw TbError.newSQLException(-90624);
    }

    protected void removeCurrentRow() throws SQLException {
        Debug.logMethod("TbRSScrollable.removeCurrentRow", new Object[]{this, new Integer(this.currentRowIndex)});
        this.checkRowIndex(this.currentRowIndex);
        this.rows.remove(this.currentRowIndex);
        --this.currentRowIndex;
        --this.rowsFetchedCnt;
    }

    public void reset() {
        super.reset();
        if (this.rows != null) {
            this.rows.clear();
            this.rows = null;
        }
    }

    protected void setRowAt(int n, Row row) throws SQLException {
        Debug.logMethod("TbRSScrollable.setRowAt", new Object[]{this, Integer.toString(n), row});
        this.rows.set(n, row);
    }
}

