/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.driver.TbCallableStatement;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.ext.TbStatementCacheEntry;
import java.sql.SQLException;

public class TbStatementCache {
    public static final int ENTRY_TYPE_TBSTATEMENT = 0;
    public static final int ENTRY_TYPE_TBPREPAREDSTATEMENT = 1;
    public static final int ENTRY_TYPE_TBCALLABLESTATEMENT = 2;
    private TbStatementCacheEntry cacheEntryHead = null;
    private TbStatementCacheEntry cacheEntryTail;
    private int cacheSize;
    private int numEntry;

    public TbStatementCache(int n) {
        this.cacheSize = n;
        this.numEntry = 0;
    }

    public boolean add(TbStatement tbStatement, int n) throws SQLException {
        if (!tbStatement.isPoolable() || this.contains(tbStatement)) {
            return false;
        }
        if (tbStatement instanceof TbPreparedStatement && ((TbPreparedStatement)tbStatement).getPPID() == null) {
            return false;
        }
        if (this.numEntry == this.cacheSize) {
            this.purgeLastEntry();
        }
        tbStatement.resetForCache();
        TbStatementCacheEntry tbStatementCacheEntry = new TbStatementCacheEntry(n);
        tbStatementCacheEntry.stmt = tbStatement;
        tbStatementCacheEntry.next = this.cacheEntryHead;
        if (this.cacheEntryHead != null) {
            this.cacheEntryHead.prev = tbStatementCacheEntry;
        }
        this.cacheEntryHead = tbStatementCacheEntry;
        if (this.cacheEntryTail == null) {
            this.cacheEntryTail = tbStatementCacheEntry;
        }
        ++this.numEntry;
        return true;
    }

    public void clear() {
        TbStatementCacheEntry tbStatementCacheEntry = this.cacheEntryHead;
        while (tbStatementCacheEntry != null) {
            try {
                tbStatementCacheEntry.clear();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            tbStatementCacheEntry = tbStatementCacheEntry.next;
        }
        this.cacheEntryHead = null;
        this.numEntry = 0;
    }

    private void purgeLastEntry() throws SQLException {
        TbStatementCacheEntry tbStatementCacheEntry = this.cacheEntryTail;
        tbStatementCacheEntry.prev.next = tbStatementCacheEntry.next;
        tbStatementCacheEntry.clear();
        this.cacheEntryTail = tbStatementCacheEntry.prev;
        --this.numEntry;
    }

    private TbStatementCacheEntry find(String string, int n, RsetType rsetType) {
        TbStatementCacheEntry tbStatementCacheEntry = this.cacheEntryHead;
        while (tbStatementCacheEntry != null) {
            String string2 = tbStatementCacheEntry.stmt.getOriginalSql();
            if (tbStatementCacheEntry.stmtType == n && tbStatementCacheEntry.stmt.getUserRsetType().equals(rsetType) && (string == null || string.equals(string2))) {
                return tbStatementCacheEntry;
            }
            tbStatementCacheEntry = tbStatementCacheEntry.next;
        }
        return null;
    }

    public boolean contains(String string, int n, RsetType rsetType) {
        return this.find(string, n, rsetType) != null;
    }

    public boolean contains(TbStatement tbStatement) {
        int n;
        String string;
        if (tbStatement instanceof TbCallableStatement) {
            string = tbStatement.getOriginalSql();
            n = 2;
        } else if (tbStatement instanceof TbPreparedStatement) {
            string = tbStatement.getOriginalSql();
            n = 1;
        } else {
            string = null;
            n = 0;
        }
        RsetType rsetType = tbStatement.getUserRsetType();
        return this.contains(string, n, rsetType);
    }

    public TbStatement get(String string, int n, RsetType rsetType) throws SQLException {
        TbStatementCacheEntry tbStatementCacheEntry = this.find(string, n, rsetType);
        if (tbStatementCacheEntry != null) {
            if (tbStatementCacheEntry.prev != null) {
                tbStatementCacheEntry.prev.next = tbStatementCacheEntry.next;
            }
            if (tbStatementCacheEntry.next != null) {
                tbStatementCacheEntry.next.prev = tbStatementCacheEntry.prev;
            }
            if (tbStatementCacheEntry == this.cacheEntryHead) {
                this.cacheEntryHead = tbStatementCacheEntry.next;
            }
            if (tbStatementCacheEntry == this.cacheEntryTail) {
                this.cacheEntryTail = tbStatementCacheEntry.prev;
            }
            if (tbStatementCacheEntry.stmt instanceof TbPreparedStatement) {
                ((TbPreparedStatement)tbStatementCacheEntry.stmt).initParameter();
            }
            --this.numEntry;
            return tbStatementCacheEntry.stmt;
        }
        return null;
    }
}

