/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbRowSet;
import com.tmax.tibero.jdbc.rowset.TbRowSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;

public class TbJdbcRowSet
extends TbRowSet {
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private static boolean isInitializedDriver;

    public TbJdbcRowSet() {
        this(null);
    }

    public TbJdbcRowSet(Connection connection) {
        Debug.logMethod("TbJdbcRowSet", new Object[]{this});
        this.conn = connection;
        isInitializedDriver = false;
    }

    public boolean absolute(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.absolute", new Object[]{this, Integer.toString(n)});
        boolean bl = this.rs.absolute(n);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public void afterLast() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.afterLast", new Object[]{this});
        if (!this.isAfterLast()) {
            this.rs.afterLast();
            this.notifyCursorMoved();
        }
    }

    public void beforeFirst() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.beforeFirst", new Object[]{this});
        if (!this.isBeforeFirst()) {
            this.rs.beforeFirst();
            this.notifyCursorMoved();
        }
    }

    public void cancelRowUpdates() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.cancelRowUpdates", new Object[]{this});
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    public void clearParameters() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.clearParameters", new Object[]{this});
        this.pstmt.clearParameters();
    }

    public void close() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.close", new Object[]{this});
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.commit();
            this.conn.close();
        }
        this.notifyRowSetChanged();
        this.isClosed = true;
    }

    public void commit() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.commit", new Object[]{this});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.commit();
    }

    public void deleteRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.deleteRow", new Object[]{this});
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    public void execute() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.execute", new Object[]{this});
        this.conn = this.getConnection(this);
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conn.setTypeMap(this.getTypeMap());
        if (this.pstmt == null) {
            this.pstmt = this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        }
        this.pstmt.setFetchSize(this.getFetchSize());
        this.pstmt.setFetchDirection(this.getFetchDirection());
        this.pstmt.setMaxFieldSize(this.getMaxFieldSize());
        this.pstmt.setMaxRows(this.getMaxRows());
        this.pstmt.setQueryTimeout(this.getQueryTimeout());
        this.pstmt.setEscapeProcessing(this.getEscapeProcessing());
        this.setParams(this.getParams(), this.pstmt);
        this.rs = this.pstmt.executeQuery();
        this.notifyRowSetChanged();
    }

    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Object[])) {
                preparedStatement.setObject(i + 1, objectArray[i]);
                continue;
            }
            Object[] objectArray2 = (Object[])objectArray[i];
            if (objectArray2.length == 2) {
                this.setParams2Arg(i, objectArray2, preparedStatement);
                continue;
            }
            if (objectArray2.length != 3) continue;
            this.setParams3Arg(i, objectArray2, preparedStatement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParams2Arg(int n, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        if (objectArray[0] == null) {
            preparedStatement.setNull(n + 1, (Integer)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Date) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setDate(n + 1, (Date)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Time) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setTime(n + 1, (Time)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Timestamp) {
            if (!(objectArray[1] instanceof Calendar)) throw TbError.newSQLException(-90846, objectArray[1].toString());
            preparedStatement.setTimestamp(n + 1, (Timestamp)objectArray[0], (Calendar)objectArray[1]);
            return;
        } else if (objectArray[0] instanceof Reader) {
            preparedStatement.setCharacterStream(n + 1, (Reader)objectArray[0], (Integer)objectArray[1]);
            return;
        } else {
            if (!(objectArray[1] instanceof Integer)) return;
            preparedStatement.setObject(n + 1, objectArray[0], (Integer)objectArray[1]);
        }
    }

    private void setParams3Arg(int n, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        block12: {
            block14: {
                block13: {
                    block11: {
                        if (objectArray[0] != null) break block11;
                        preparedStatement.setNull(n + 1, (Integer)objectArray[1], (String)objectArray[2]);
                        break block12;
                    }
                    if (!(objectArray[0] instanceof Reader)) break block13;
                    switch ((Integer)objectArray[2]) {
                        case 3: {
                            if (objectArray[1] instanceof Integer) {
                                preparedStatement.setCharacterStream(n + 1, (Reader)objectArray[0], (Integer)objectArray[1]);
                            }
                            break block12;
                        }
                        default: {
                            throw TbError.newSQLException(-90846, ((Integer)objectArray[2]).toString());
                        }
                    }
                }
                if (!(objectArray[0] instanceof InputStream)) break block14;
                switch ((Integer)objectArray[2]) {
                    case 2: {
                        if (objectArray[1] instanceof Integer) {
                            preparedStatement.setBinaryStream(n + 1, (InputStream)objectArray[0], (Integer)objectArray[1]);
                        }
                        break block12;
                    }
                    case 1: {
                        preparedStatement.setAsciiStream(n + 1, (InputStream)objectArray[0], (Integer)objectArray[1]);
                        break block12;
                    }
                    default: {
                        throw TbError.newSQLException(-90846, ((Integer)objectArray[2]).toString());
                    }
                }
            }
            if (objectArray[1] instanceof Integer && objectArray[2] instanceof Integer) {
                preparedStatement.setObject(n + 1, objectArray[0], (Integer)objectArray[1], (int)((Integer)objectArray[2]));
            } else {
                throw TbError.newSQLException(-90846, objectArray[0].toString());
            }
        }
    }

    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    public boolean first() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.first", new Object[]{this});
        boolean bl = this.rs.first();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public Array getArray(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getArray", new Object[]{this, Integer.toString(n)});
        return this.rs.getArray(n);
    }

    public Array getArray(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getArray", new Object[]{this, string});
        return this.rs.getArray(string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getAsciiStream", new Object[]{this, Integer.toString(n)});
        return this.rs.getAsciiStream(n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getAsciiStream", new Object[]{this, string});
        return this.rs.getAsciiStream(string);
    }

    public boolean getAutoCommit() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getAutoCommit", new Object[]{this});
        if (this.conn != null) {
            return this.conn.getAutoCommit();
        }
        throw TbError.newSQLException(-90827);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, Integer.toString(n)});
        return this.rs.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, Integer.toString(n), Integer.toString(n2)});
        return this.rs.getBigDecimal(n, n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, string});
        return this.rs.getBigDecimal(string);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, string});
        return this.rs.getBigDecimal(string, n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBinaryStream", new Object[]{this, Integer.toString(n)});
        return this.rs.getBinaryStream(n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBinaryStream", new Object[]{this, string});
        return this.rs.getBinaryStream(string);
    }

    public Blob getBlob(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBlob", new Object[]{this, Integer.toString(n)});
        return this.rs.getBlob(n);
    }

    public Blob getBlob(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBlob", new Object[]{this, string});
        return this.rs.getBlob(string);
    }

    public boolean getBoolean(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBoolean", new Object[]{this, Integer.toString(n)});
        return this.rs.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBoolean", new Object[]{this, string});
        return this.rs.getBoolean(string);
    }

    public byte getByte(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getByte", new Object[]{this, Integer.toString(n)});
        return this.rs.getByte(n);
    }

    public byte getByte(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getByte", new Object[]{this, string});
        return this.rs.getByte(string);
    }

    public byte[] getBytes(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBytes", new Object[]{this, Integer.toString(n)});
        return this.rs.getBytes(n);
    }

    public byte[] getBytes(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBytes", new Object[]{this, string});
        return this.rs.getBytes(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getCharacterStream", new Object[]{this, Integer.toString(n)});
        return this.rs.getCharacterStream(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getCharacterStream", new Object[]{this, string});
        return this.rs.getCharacterStream(string);
    }

    public Clob getClob(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getClob", new Object[]{this, Integer.toString(n)});
        return this.rs.getClob(n);
    }

    public Clob getClob(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getClob", new Object[]{this, string});
        return this.rs.getClob(string);
    }

    public int getConcurrency() throws SQLException {
        return super.getConcurrency();
    }

    private Connection getConnection(RowSet rowSet) throws SQLException {
        String string = rowSet.getUrl();
        String string2 = rowSet.getUsername();
        String string3 = rowSet.getPassword();
        String string4 = rowSet.getDataSourceName();
        if (this.conn != null && !this.conn.isClosed()) {
            return this.conn;
        }
        if (string4 != null && !string4.equals("")) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(string4);
                if (string2 == null || string3 == null) {
                    return dataSource.getConnection();
                }
                return dataSource.getConnection(string2, string3);
            }
            catch (NamingException namingException) {
                throw TbError.newSQLException(-90828);
            }
        }
        if (string != null && !string.equals("")) {
            if (!isInitializedDriver) {
                DriverManager.registerDriver(new TbDriver());
                isInitializedDriver = true;
            }
            if (string2.equals("") || string3.equals("")) {
                throw TbError.newSQLException(-90854);
            }
            return DriverManager.getConnection(string, string2, string3);
        }
        throw TbError.newSQLException(-90852);
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public Date getDate(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, Integer.toString(n)});
        return this.rs.getDate(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, Integer.toString(n), calendar});
        return this.rs.getDate(n, calendar);
    }

    public Date getDate(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, string});
        return this.rs.getDate(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, string, calendar});
        return this.rs.getDate(string, calendar);
    }

    public double getDouble(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDouble", new Object[]{this, Integer.toString(n)});
        return this.rs.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDouble", new Object[]{this, string});
        return this.rs.getDouble(string);
    }

    public float getFloat(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getFloat", new Object[]{this, Integer.toString(n)});
        return this.rs.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getFloat", new Object[]{this, string});
        return this.rs.getFloat(string);
    }

    public int getInt(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getInt", new Object[]{this, Integer.toString(n)});
        return this.rs.getInt(n);
    }

    public int getInt(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getInt", new Object[]{this, string});
        return this.rs.getInt(string);
    }

    public long getLong(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getLong", new Object[]{this, Integer.toString(n)});
        return this.rs.getLong(n);
    }

    public long getLong(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getLong", new Object[]{this, string});
        return this.rs.getLong(string);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbRowSetMetaData(this.rs.getMetaData());
    }

    public Object getObject(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, Integer.toString(n)});
        return this.rs.getObject(n);
    }

    public Object getObject(int n, Map map) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, Integer.toString(n), map});
        return this.rs.getObject(n, map);
    }

    public Object getObject(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, string});
        return this.rs.getObject(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, string});
        return this.rs.getObject(string, map);
    }

    public Ref getRef(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getRef", new Object[]{this, Integer.toString(n)});
        return this.rs.getRef(n);
    }

    public Ref getRef(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getRef", new Object[]{this, string});
        return this.rs.getRef(string);
    }

    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    public short getShort(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getShort", new Object[]{this, Integer.toString(n)});
        return this.rs.getShort(n);
    }

    public short getShort(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getShort", new Object[]{this, string});
        return this.rs.getShort(string);
    }

    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    public String getString(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getString", new Object[]{this, Integer.toString(n)});
        return this.rs.getString(n);
    }

    public String getString(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getString", new Object[]{this, string});
        return this.rs.getString(string);
    }

    public Time getTime(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, Integer.toString(n)});
        return this.rs.getTime(n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, Integer.toString(n), calendar});
        return this.rs.getTime(n, calendar);
    }

    public Time getTime(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, string});
        return this.rs.getTime(string);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, string, calendar});
        return this.rs.getTime(string, calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, Integer.toString(n)});
        return this.rs.getTimestamp(n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, Integer.toString(n), calendar});
        return this.rs.getTimestamp(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, string});
        return this.rs.getTimestamp(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, string, calendar});
        return this.rs.getTimestamp(string, calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getUnicodeStream", new Object[]{this, Integer.toString(n)});
        return this.rs.getUnicodeStream(n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getUnicodeStream", new Object[]{this, string});
        return this.rs.getUnicodeStream(string);
    }

    public URL getURL(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getURL", new Object[]{this, Integer.toString(n)});
        return this.rs.getURL(n);
    }

    public URL getURL(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getURL", new Object[]{this, string});
        return this.rs.getURL(string);
    }

    public void insertRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.insertRow", new Object[]{this});
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }

    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.last", new Object[]{this});
        boolean bl = this.rs.last();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public void moveToCurrentRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.moveToCurrentRow", new Object[]{this});
        this.rs.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.moveToInsertRow", new Object[]{this});
        this.rs.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.next", new Object[]{this});
        boolean bl = this.rs.next();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public boolean previous() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.previous", new Object[]{this});
        boolean bl = this.rs.previous();
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public void refreshRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.refreshRow", new Object[]{this});
        this.rs.refreshRow();
    }

    public boolean relative(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.relative", new Object[]{this, Integer.toString(n)});
        boolean bl = this.rs.relative(n);
        if (bl) {
            this.notifyCursorMoved();
        }
        return bl;
    }

    public void rollback() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.rollback", new Object[]{this});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.rollback", new Object[]{this, savepoint});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.rollback(savepoint);
    }

    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.setAutoCommit", new Object[]{this, new Boolean(bl)});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.setAutoCommit(bl);
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        if (bl) {
            throw TbError.newSQLException(-90856);
        }
        super.setShowDeleted(bl);
    }

    public void updateArray(int n, Array array) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateArray", new Object[]{this, Integer.toString(n), array});
        this.rs.updateArray(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateArray", new Object[]{this, string, array});
        this.rs.updateArray(string, array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, Integer.toString(n), inputStream, Integer.toString(n2)});
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, string, inputStream, Integer.toString(n)});
        this.rs.updateAsciiStream(string, inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBigDecimal", new Object[]{this, Integer.toString(n), bigDecimal});
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBigDecimal", new Object[]{this, string, bigDecimal});
        this.rs.updateBigDecimal(string, bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, Integer.toString(n), inputStream, Integer.toString(n2)});
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, string, inputStream, Integer.toString(n)});
        this.rs.updateBinaryStream(string, inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, Integer.toString(n), blob});
        this.rs.updateBlob(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, string, blob});
        this.rs.updateBlob(string, blob);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBoolean", new Object[]{this, Integer.toString(n), new Boolean(bl)});
        this.rs.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBoolean", new Object[]{this, string, new Boolean(bl)});
        this.rs.updateBoolean(string, bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateByte", new Object[]{this, Integer.toString(n), Byte.toString(by)});
        this.rs.updateByte(n, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateByte", new Object[]{this, string, Byte.toString(by)});
        this.rs.updateByte(string, by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBytes", new Object[]{this, Integer.toString(n), byArray});
        this.rs.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBytes", new Object[]{this, string, byArray});
        this.rs.updateBytes(string, byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, Integer.toString(n), reader, Integer.toString(n2)});
        this.rs.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, string, reader, Integer.toString(n)});
        this.rs.updateCharacterStream(string, reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, Integer.toString(n), clob});
        this.rs.updateClob(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, string, clob});
        this.rs.updateClob(string, clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDate", new Object[]{this, Integer.toString(n), date});
        this.rs.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDate", new Object[]{this, string, date});
        this.rs.updateDate(string, date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDouble", new Object[]{this, Integer.toString(n), Double.toString(d)});
        this.rs.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDouble", new Object[]{this, string, Double.toString(d)});
        this.rs.updateDouble(string, d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateFloat", new Object[]{this, Integer.toString(n), Float.toString(f)});
        this.rs.updateFloat(n, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateFloat", new Object[]{this, string, Float.toString(f)});
        this.rs.updateFloat(string, f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateInt", new Object[]{this, Integer.toString(n), Integer.toString(n2)});
        this.rs.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateInt", new Object[]{this, string, Integer.toString(n)});
        this.rs.updateInt(string, n);
    }

    public void updateLong(int n, long l) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateLong", new Object[]{this, Integer.toString(n), Long.toString(l)});
        this.rs.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateLong", new Object[]{this, string, Long.toString(l)});
        this.rs.updateLong(string, l);
    }

    public void updateNull(int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNull", new Object[]{this, Integer.toString(n)});
        this.rs.updateNull(n);
    }

    public void updateNull(String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNString", new Object[]{this, string});
        this.rs.updateNull(string);
    }

    public void updateObject(int n, Object object) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, Integer.toString(n), object});
        this.rs.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, Integer.toString(n), object, Integer.toString(n2)});
        this.rs.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, string, object});
        this.rs.updateObject(string, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, string, object, Integer.toString(n)});
        this.rs.updateObject(string, object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRef", new Object[]{this, Integer.toString(n), ref});
        this.rs.updateRef(n, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRef", new Object[]{this, string, ref});
        this.rs.updateRef(string, ref);
    }

    public void updateRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRow", new Object[]{this});
        this.rs.updateRow();
    }

    public void updateShort(int n, short s) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateShort", new Object[]{this, Integer.toString(n), Short.toString(s)});
        this.rs.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateShort", new Object[]{this, string, Short.toString(s)});
        this.rs.updateShort(string, s);
    }

    public void updateString(int n, String string) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateString", new Object[]{this, Integer.toString(n), string});
        this.rs.updateString(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateString", new Object[]{this, string, string2});
        this.rs.updateString(string, string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTime", new Object[]{this, Integer.toString(n), time});
        this.rs.updateTime(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTime", new Object[]{this, string, time});
        this.rs.updateTime(string, time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTimestamp", new Object[]{this, Integer.toString(n), timestamp});
        this.rs.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTimestamp", new Object[]{this, string, timestamp});
        this.rs.updateTimestamp(string, timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }
}

