/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.renderer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tiles.Attribute;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.renderer.RendererException;
import org.apache.tiles.renderer.TypeDetectingAttributeRenderer;
import org.apache.tiles.renderer.impl.AbstractBaseAttributeRenderer;

public class ChainedDelegateAttributeRenderer
extends AbstractBaseAttributeRenderer {
    private List<TypeDetectingAttributeRenderer> renderers = new ArrayList<TypeDetectingAttributeRenderer>();

    public void addAttributeRenderer(TypeDetectingAttributeRenderer renderer) {
        this.renderers.add(renderer);
    }

    public void write(Object value, Attribute attribute, TilesRequestContext request) throws IOException {
        if (value == null) {
            throw new NullPointerException("The attribute value is null");
        }
        for (TypeDetectingAttributeRenderer renderer : this.renderers) {
            if (!renderer.isRenderable(value, attribute, request)) continue;
            renderer.render(attribute, request);
            return;
        }
        throw new RendererException("Type of the attribute not found, class '" + value.getClass() + "' value '" + value.toString() + "'");
    }
}

