/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaleUtil {
    public static final Locale NULL_LOCALE = new Locale("");

    private LocaleUtil() {
    }

    public static List<String> calculatePostfixes(Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        ArrayList<String> result = new ArrayList<String>();
        result.add("");
        if (locale == null) {
            return result;
        }
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer();
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.add(temp.toString());
        return result;
    }

    public static String calculatePostfix(Locale locale) {
        if (locale == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (!"".equals(language)) {
            builder.append("_");
            builder.append(language);
            if (!"".equals(country)) {
                builder.append("_");
                builder.append(country);
                if (!"".equals(variant)) {
                    builder.append("_");
                    builder.append(variant);
                }
            }
        }
        return builder.toString();
    }

    public static String concatPostfix(String name, String postfix) {
        if (postfix == null || "".equals(postfix)) {
            return name;
        }
        int dotIndex = name.lastIndexOf(".");
        int lastNameStart = name.lastIndexOf(File.pathSeparator);
        if (dotIndex < 1 || dotIndex < lastNameStart) {
            return name + postfix;
        }
        String ext = name.substring(dotIndex);
        name = name.substring(0, dotIndex);
        return name + postfix + ext;
    }

    public static Locale getParentLocale(Locale locale) {
        Locale retValue = null;
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (!"".equals(variant)) {
            retValue = new Locale(language, country);
        } else if (!"".equals(country)) {
            retValue = new Locale(language);
        } else if (!"".equals(language)) {
            retValue = NULL_LOCALE;
        }
        return retValue;
    }
}

