/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.mvel;

import java.util.HashMap;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextHolder;
import org.mvel2.UnresolveablePropertyException;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.impl.BaseVariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesContextBeanVariableResolverFactory
extends BaseVariableResolverFactory {
    private TilesRequestContextHolder requestHolder;

    public TilesContextBeanVariableResolverFactory(TilesRequestContextHolder requestHolder) {
        this.requestHolder = requestHolder;
        this.variableResolvers = new HashMap();
    }

    public VariableResolver createVariable(String name, Object value) {
        if (this.nextFactory != null) {
            return this.nextFactory.createVariable(name, value);
        }
        throw new UnsupportedOperationException("This variable resolver factory is read only");
    }

    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        this.variableResolvers = new HashMap();
        if (this.nextFactory != null) {
            return this.nextFactory.createVariable(name, value, type);
        }
        throw new UnsupportedOperationException("This variable resolver factory is read only");
    }

    public boolean isResolveable(String name) {
        return this.isTarget(name) || this.isNextResolveable(name);
    }

    public VariableResolver getVariableResolver(String name) {
        if (this.isResolveable(name)) {
            if (this.variableResolvers != null && this.variableResolvers.containsKey(name)) {
                return (VariableResolver)this.variableResolvers.get(name);
            }
            if (this.isTarget(name)) {
                TilesContextBeanVariableResolver variableResolver = new TilesContextBeanVariableResolver(name);
                this.variableResolvers.put(name, variableResolver);
                return variableResolver;
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name);
            }
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
    }

    public boolean isTarget(String name) {
        TilesRequestContext request = this.requestHolder.getTilesRequestContext();
        return request.getRequestScope().containsKey(name) || request.getSessionScope().containsKey(name) || request.getApplicationContext().getApplicationScope().containsKey(name);
    }

    private class TilesContextBeanVariableResolver
    implements VariableResolver {
        private String name;

        public TilesContextBeanVariableResolver(String name) {
            this.name = name;
        }

        public int getFlags() {
            return 0;
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            Object value = this.getValue();
            if (value != null) {
                return value.getClass();
            }
            return Object.class;
        }

        public Object getValue() {
            TilesRequestContext request = TilesContextBeanVariableResolverFactory.this.requestHolder.getTilesRequestContext();
            Object value = request.getRequestScope().get(this.name);
            if (value == null && (value = request.getSessionScope().get(this.name)) == null) {
                value = request.getApplicationContext().getApplicationScope().get(this.name);
            }
            return value;
        }

        public void setStaticType(Class type) {
        }

        public void setValue(Object value) {
            throw new UnsupportedOperationException("This resolver is read-only");
        }
    }
}

