/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.config;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@ConfigurationProperties(prefix="application.scheduling")
public class TsiSchedulingConfig
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(TsiSchedulingConfig.class);
    private int poolCore = 0;
    private final int SCHEDULE_THREAD_POOL_SIZE = 10;

    @PostConstruct
    private void init() {
        log.info("[{}] ------------", (Object)this.getClass().getSimpleName());
        if (this.poolCore == 0) {
            log.warn("[{}] poolCore size set as default: {} EA.", (Object)this.getClass().getSimpleName(), (Object)this.poolCore);
            this.poolCore = 10;
        }
        log.info("[{}] poolCore: {} EA.", (Object)this.getClass().getSimpleName(), (Object)this.poolCore);
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(10);
        threadPoolTaskScheduler.setThreadNamePrefix("scheduler-");
        threadPoolTaskScheduler.initialize();
        scheduledTaskRegistrar.setTaskScheduler((TaskScheduler)threadPoolTaskScheduler);
    }

    public int getPoolCore() {
        return this.poolCore;
    }

    public int getSCHEDULE_THREAD_POOL_SIZE() {
        this.getClass();
        return 10;
    }

    public void setPoolCore(int poolCore) {
        this.poolCore = poolCore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsiSchedulingConfig)) {
            return false;
        }
        TsiSchedulingConfig other = (TsiSchedulingConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPoolCore() != other.getPoolCore()) {
            return false;
        }
        return this.getSCHEDULE_THREAD_POOL_SIZE() == other.getSCHEDULE_THREAD_POOL_SIZE();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsiSchedulingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPoolCore();
        result = result * 59 + this.getSCHEDULE_THREAD_POOL_SIZE();
        return result;
    }

    public String toString() {
        return "TsiSchedulingConfig(poolCore=" + this.getPoolCore() + ", SCHEDULE_THREAD_POOL_SIZE=" + this.getSCHEDULE_THREAD_POOL_SIZE() + ")";
    }
}

