/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.controller;

import com.tsi.api.server.controller.result.AbstractTscSsipApiResult;
import com.tsi.api.server.controller.result.TscSsipApiResultBrokerInfo;
import com.tsi.api.server.controller.result.TscSsipApiResultError;
import com.tsi.api.server.controller.result.TscSsipApiResultKafkaAuth;
import com.tsi.api.server.controller.result.TscSsipApiResultKafkaTokenInfo;
import com.tsi.api.server.controller.result.TscSsipApiResultNodeInfo;
import com.tsi.api.server.controller.result.TscSsipApiResultSystemStatus;
import com.tsi.api.server.dto.KafkaTokenAuthDto;
import com.tsi.api.server.dto.KafkaTokenDto;
import com.tsi.api.server.dto.SystemStatus2Dto;
import com.tsi.api.server.dto.SystemStatusDto;
import com.tsi.api.server.error.TscSsipApiErrorCode;
import com.tsi.api.server.repository.TsiSystemStatusManager;
import com.tsi.api.server.service.TscSsipApiService;
import com.tsi.api.server.service.TscSsipKafkaTokenService;
import com.tsi.api.server.util.ApiUtils;
import com.tsi.api.server.vo.ApiInvokeVo;
import com.tsi.api.server.vo.BrokerVo;
import com.tsi.api.server.vo.KafkaAuthorizedVo;
import com.tsi.api.server.vo.SystemStatusVo;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TscSsipApiController {
    private static final Logger log = LoggerFactory.getLogger(TscSsipApiController.class);
    private final String SSIP_API_NODE_INFO = "/api/nodeInfo/{apiToken}";
    private final String SSIP_API_BROKER_INFO = "/api/brokerInfo/{apiToken}";
    private final String SSIP_API_UUID = "/api/uuid";
    private final String SSIP_API_SYSTEM_STATUS = "/api/system-status";
    private final String SSIP_API_SYSTEM_STATUS2 = "/api/system-status2";
    private final String SSIP_API_KAFKA_TOKEN = "/api/kafka/token/{apiToken}";
    private final String SSIP_API_KAFKA_AUTH = "/api/kafka/auth";
    private final TscSsipApiService tscSsipApiService;
    private final TscSsipKafkaTokenService tscSsipKafkaTokenService;

    public TscSsipApiController(TscSsipApiService tscSsipApiService, TscSsipKafkaTokenService tscSsipKafkaTokenService) {
        this.tscSsipApiService = tscSsipApiService;
        this.tscSsipKafkaTokenService = tscSsipKafkaTokenService;
    }

    @GetMapping(value={"/api/nodeInfo/{apiToken}"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> getNodeInfo(@PathVariable(value="apiToken") String apiToken, HttpServletRequest request) {
        String apiId = "/api/nodeInfo/{apiToken}";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, apiToken});
        ApiInvokeVo apiInvokeVo = ApiInvokeVo.builder().apiId(apiId).apiToken(apiToken).ipAddr(remoteIP).error(TscSsipApiErrorCode.SUCCESS.getCode()).build();
        try {
            TscSsipApiErrorCode authorizedInfo = this.tscSsipApiService.getAuthorizedInfo(apiId, apiToken, remoteIP);
            if (authorizedInfo != TscSsipApiErrorCode.SUCCESS) {
                log.error("\uc778\uc99d\uc624\ub958: [{}] ==> [{}]: [{}].[{}]" + apiId, new Object[]{remoteIP, apiToken, authorizedInfo.getCode(), authorizedInfo.getMessage()});
                apiInvokeVo.setError(authorizedInfo.getCode());
                this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
                TscSsipApiResultError error = new TscSsipApiResultError(authorizedInfo.getCode(), authorizedInfo.getMessage());
                return new ResponseEntity((Object)error, HttpStatus.UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            log.error("getNodeInfo: {}", (Object)e.getMessage());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            apiInvokeVo.setError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode());
            this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        TscSsipApiResultNodeInfo result = new TscSsipApiResultNodeInfo(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        result.setNodes(this.tscSsipApiService.getNodeInfoList());
        result.setCount(result.getNodes().size());
        this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @GetMapping(value={"/api/brokerInfo/{apiToken}"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> getBrokerInfo(@PathVariable(value="apiToken") String apiToken, HttpServletRequest request) {
        String apiId = "/api/brokerInfo/{apiToken}";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, apiToken});
        ApiInvokeVo apiInvokeVo = ApiInvokeVo.builder().apiId(apiId).apiToken(apiToken).ipAddr(remoteIP).error(TscSsipApiErrorCode.SUCCESS.getCode()).build();
        try {
            TscSsipApiErrorCode authorizedInfo = this.tscSsipApiService.getAuthorizedInfo(apiId, apiToken, remoteIP);
            if (authorizedInfo != TscSsipApiErrorCode.SUCCESS) {
                log.error("\uc778\uc99d\uc624\ub958: [{}] ==> [{}]: [{}].[{}]" + apiId, new Object[]{remoteIP, apiToken, authorizedInfo.getCode(), authorizedInfo.getMessage()});
                apiInvokeVo.setError(authorizedInfo.getCode());
                this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
                TscSsipApiResultError error = new TscSsipApiResultError(authorizedInfo.getCode(), authorizedInfo.getMessage());
                return new ResponseEntity((Object)error, HttpStatus.UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            log.error("getBrokerInfo: {}", (Object)e.getMessage());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        BrokerVo brokerVo = null;
        try {
            brokerVo = this.tscSsipApiService.getBrokerInfo(apiToken);
            if (brokerVo == null) {
                apiInvokeVo.setError(TscSsipApiErrorCode.NOTFOUND_BROKER_INFO.getCode());
                log.error("{}", (Object)apiInvokeVo.toString());
                this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
                TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.NOTFOUND_BROKER_INFO.getCode(), TscSsipApiErrorCode.NOTFOUND_BROKER_INFO.getMessage());
                return new ResponseEntity((Object)error, HttpStatus.NON_AUTHORITATIVE_INFORMATION);
            }
        }
        catch (Exception e) {
            log.error("getBrokerInfo: {}", (Object)e.getMessage());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            apiInvokeVo.setError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode());
            this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        TscSsipApiResultBrokerInfo result = new TscSsipApiResultBrokerInfo(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        result.setBrokerInfo(brokerVo);
        result.setCount(1);
        this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @GetMapping(value={"/api/uuid"})
    public String getUUID() {
        String uid = UUID.randomUUID().toString();
        uid = uid.replace("-", "").toUpperCase();
        return uid;
    }

    @PostMapping(value={"/api/system-status"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> registerSystemStatus(@RequestBody SystemStatusDto status, HttpServletRequest request) {
        String apiId = "/api/system-status";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.debug("{}, {}, {}", new Object[]{apiId, remoteIP, status.toString()});
        SystemStatusVo vo = TsiSystemStatusManager.getInstance().get(status.getHostName());
        if (vo == null) {
            vo = new SystemStatusVo();
            vo.setHostName(status.getHostName());
            TsiSystemStatusManager.getInstance().put(status.getHostName(), vo);
        }
        try {
            float used;
            vo.setOsType(status.getOsType());
            vo.setOsName(status.getOsName());
            vo.setOsType(status.getOsType());
            vo.setOsVersion(status.getOsVersion());
            vo.setOsArch(status.getOsArch());
            vo.setKernelRelease(status.getKernelRelease());
            vo.setInternalIp(status.getInternalIp());
            vo.setExternalIp(status.getExternalIp());
            vo.setSwapMem(status.getSwapMem());
            vo.setCpuCnt(status.getCpuCnt());
            vo.setUpTimes(status.getUpTimes());
            vo.setUseCpuRate(status.getUseCpuRate());
            vo.setTasks(status.getTasks());
            vo.setThreads(status.getThreads());
            vo.setLoadAvg(status.getLoadAvg());
            if (status.getTotalDisk() > 0L) {
                double dblTotal = status.getTotalDisk();
                double dblUsed = status.getUsedDisk();
                status.setUseDiskRate((float)(dblUsed / dblTotal * 100.0));
                if ((double)status.getUseDiskRate() > 100.0) {
                    status.setUseDiskRate(100.0f);
                }
                status.setTotalDisk(status.getTotalDisk() / 1024L);
                vo.setTotalDisk((float)(dblTotal / 1024.0 / 1024.0));
                vo.setUseDisk((float)(dblUsed / 1024.0 / 1024.0));
                vo.setUseDiskRate(status.getUseDiskRate());
            }
            if (status.getSwapMem() > 0L && status.getUsedSwap() > 0) {
                float total = status.getSwapMem();
                used = status.getUsedSwap();
                status.setUseSwapRate((float)((double)(used / total) * 100.0));
                if ((double)status.getUsedSwap() > 100.0) {
                    status.setUseSwapRate(100.0f);
                }
            }
            if (status.getTotalMem() > 0L) {
                float total = status.getTotalMem();
                used = total - (float)status.getFreeMem();
                status.setUseMemRate((float)((double)(used / total) * 100.0));
                if ((double)status.getUseMemRate() > 100.0) {
                    status.setUseMemRate(100.0f);
                }
                used = total - (float)status.getFreeMem() - (float)status.getCacheMem();
                status.setRealMemRate((float)((double)(used / total) * 100.0));
                if ((double)status.getRealMemRate() > 100.0) {
                    status.setRealMemRate(100.0f);
                }
                vo.setTotalMem(total / 1024.0f);
                vo.setUseMem(used / 1024.0f);
                vo.setUseMemRate(status.getRealMemRate());
            }
            vo.setUpdateTm(System.currentTimeMillis());
            vo.setUpdate(true);
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage().toString());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        TscSsipApiResultSystemStatus result = new TscSsipApiResultSystemStatus(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        result.setResult("ok");
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/api/system-status2"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> registerSystemStatus2(@RequestBody SystemStatus2Dto status, HttpServletRequest request) {
        String apiId = "/api/system-status2";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.debug("{}, {}, {}", new Object[]{apiId, remoteIP, status.toString()});
        SystemStatusVo vo = TsiSystemStatusManager.getInstance().get(status.getHostName());
        if (vo == null) {
            vo = new SystemStatusVo();
            vo.setHostName(status.getHostName());
            TsiSystemStatusManager.getInstance().put(status.getHostName(), vo);
        }
        try {
            vo.setUseCpuRate(status.getCpuLoad());
            vo.setLoadAvg(status.getCpuLoad());
            vo.setUseDiskRate(status.getDisUsage());
            vo.setUseMemRate(status.getMemoryUsage());
            vo.setUpdateTm(System.currentTimeMillis());
            vo.setUpdate(true);
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage().toString());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        TscSsipApiResultSystemStatus result = new TscSsipApiResultSystemStatus(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        result.setResult("ok");
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @GetMapping(value={"/api/kafka/token/{apiToken}"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> getKafkaToken(@PathVariable(value="apiToken") String apiToken, HttpServletRequest request) {
        String apiId = "/api/kafka/token/{apiToken}";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, apiToken});
        ApiInvokeVo apiInvokeVo = ApiInvokeVo.builder().apiId(apiId).apiToken(apiToken).ipAddr(remoteIP).error(TscSsipApiErrorCode.SUCCESS.getCode()).build();
        KafkaAuthorizedVo authorizedVo = null;
        try {
            authorizedVo = this.tscSsipApiService.getKafkaAuthorizedInfo(apiToken, remoteIP, true);
            if (authorizedVo.getErrorCode() != TscSsipApiErrorCode.SUCCESS) {
                log.error("\uc778\uc99d\uc624\ub958: [{}] ==> [{}]: [{}].[{}]" + apiId, new Object[]{remoteIP, apiToken, authorizedVo.getErrorCode(), authorizedVo.getErrorCode().getMessage()});
                apiInvokeVo.setError(authorizedVo.getErrorCode().getCode());
                this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
                TscSsipApiResultError error = new TscSsipApiResultError(authorizedVo.getErrorCode().getCode(), authorizedVo.getErrorCode().getMessage());
                return new ResponseEntity((Object)error, HttpStatus.UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            log.error("tscSsipKafkaTokenService: {}", (Object)e.getMessage());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            apiInvokeVo.setError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode());
            this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        KafkaTokenDto token = this.tscSsipKafkaTokenService.generateToken(apiToken, authorizedVo.getBrokerId(), authorizedVo.getBrokerPwd(), "KAFKA");
        TscSsipApiResultKafkaTokenInfo result = new TscSsipApiResultKafkaTokenInfo(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        result.setAccessToken(token.getToken());
        result.setCount(1);
        this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/api/kafka/auth"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> getKafkaAuth(@RequestBody KafkaTokenAuthDto token, HttpServletRequest request) {
        String apiId = "/api/kafka/auth";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, token});
        String resultCode = String.valueOf(TscSsipApiErrorCode.SUCCESS.getCode());
        TscSsipApiResultKafkaAuth result = new TscSsipApiResultKafkaAuth(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        ApiInvokeVo apiInvokeVo = ApiInvokeVo.builder().apiId(apiId).apiToken(token.getApiToken()).ipAddr(remoteIP).error(TscSsipApiErrorCode.SUCCESS.getCode()).build();
        KafkaAuthorizedVo authorizedVo = null;
        try {
            authorizedVo = this.tscSsipApiService.getKafkaAuthorizedInfo(token.getApiToken(), remoteIP, false);
            if (authorizedVo.getErrorCode() != TscSsipApiErrorCode.SUCCESS) {
                log.error("\uc778\uc99d\uc624\ub958: [{}] ==> [{}]: [{}].[{}]" + apiId, new Object[]{remoteIP, token.getApiToken(), authorizedVo.getErrorCode(), authorizedVo.getErrorCode().getMessage()});
                apiInvokeVo.setError(authorizedVo.getErrorCode().getCode());
                this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
                TscSsipApiResultError error = new TscSsipApiResultError(authorizedVo.getErrorCode().getCode(), authorizedVo.getErrorCode().getMessage());
                return new ResponseEntity((Object)error, HttpStatus.UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            log.error("Exception: {}", (Throwable)e);
            apiInvokeVo.setError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode());
            resultCode = String.valueOf(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode());
            result.setResult(resultCode);
            this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        try {
            log.info("token.getAccessToken(): {}", (Object)token.getAccessToken());
            if (token.getAccessToken() != null && this.tscSsipKafkaTokenService.verifyToken(token.getAccessToken())) {
                KafkaTokenDto tokenDto = this.tscSsipKafkaTokenService.decode(token.getAccessToken());
                log.info("tokenDto: {}", (Object)tokenDto);
                if (tokenDto.getApiToken() != null && tokenDto.getApiToken().equals(token.getApiToken())) {
                    log.info("getApiToken: [{}] -- [{}]", (Object)tokenDto.getApiToken(), (Object)token.getApiToken());
                    if (tokenDto.getUid() == null || tokenDto.getPwd() == null || !tokenDto.getUid().equals(authorizedVo.getBrokerId()) || !tokenDto.getPwd().equals(authorizedVo.getBrokerPwd())) {
                        log.info("tokenDto: {}", (Object)tokenDto);
                        apiInvokeVo.setError(TscSsipApiErrorCode.NOTFOUND_URL.getCode());
                        resultCode = String.valueOf(TscSsipApiErrorCode.NOTFOUND_URL.getCode());
                    }
                } else {
                    log.info("error getApiToken: [{}] -- [{}]", (Object)tokenDto.getApiToken(), (Object)token.getApiToken());
                    apiInvokeVo.setError(TscSsipApiErrorCode.UNREGISTERED_APITOKEN.getCode());
                    resultCode = String.valueOf(TscSsipApiErrorCode.UNREGISTERED_APITOKEN.getCode());
                }
            } else {
                log.info("{}", (Object)token);
                apiInvokeVo.setError(TscSsipApiErrorCode.APITOKEN_EXPIRED.getCode());
                resultCode = String.valueOf(TscSsipApiErrorCode.APITOKEN_EXPIRED.getCode());
            }
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.getMessage());
            apiInvokeVo.setError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode());
            resultCode = String.valueOf(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode());
        }
        result.setResult(resultCode);
        this.tscSsipApiService.insertInvokeHs(apiInvokeVo, true);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }
}

