/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.mybatis;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class MybatisConfig {
    @Value(value="${spring.datasource.mybatis.mapper-locations:classpath:mybatis/mapper/**/*.xml}")
    String mapperLocations;

    @PostConstruct
    private void init() {
    }

    @Primary
    @Bean(name={"dataSource"})
    @ConfigurationProperties(prefix="spring.datasource.mybatis")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactoryBean(@Autowired @Qualifier(value="dataSource") DataSource dataSource, ApplicationContext applicationContext) throws Exception {
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        factoryBean.setMapperLocations(applicationContext.getResources(this.mapperLocations));
        return factoryBean.getObject();
    }

    @Primary
    @Bean(name={"sqlSession"})
    public SqlSessionTemplate sqlSession(@Autowired @Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Primary
    @Bean(name={"transactionManager"})
    public DataSourceTransactionManager transactionManager(@Autowired @Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

