/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server;

import com.tsi.api.server.mybatis.TsiDatabaseService;
import com.tsi.api.server.mybatis.vo.AlarmOccrVo;
import com.tsi.api.server.repository.TsiAlarmManager;
import com.tsi.api.server.vo.TsiAlarmConfigVo;
import com.tsi.app.common.app.AppUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;

@MapperScan(basePackageClasses={TsiApiServerApplication.class})
@SpringBootApplication
@ComponentScan(basePackages={"com.tsi.app.common", "com.tsi.api.server.config", "com.tsi.api.server"})
public class TsiApiServerApplication
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TsiApiServerApplication.class);
    private static String applicationName = "tsi-api-server";

    @PostConstruct
    public void started() {
    }

    public static void main(String[] args) {
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{TsiApiServerApplication.class}).listeners(new ApplicationListener[]{new ApplicationPidFileWriter("./conf/" + applicationName + ".pid")}).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(String ... args) throws Exception {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                               TSI CVIM System                                  **");
        log.info("**                           CVIM API Server Program.                             **");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)sdfDate.format(new Date()));
        log.info("************************************************************************************");
        TsiAlarmManager.getInstance().getProcessStateVo().setProcessId(applicationName);
        try {
            TsiDatabaseService tsiDatabaseService = (TsiDatabaseService)AppUtils.getBean(TsiDatabaseService.class);
            AlarmOccrVo alarm = new AlarmOccrVo(4);
            alarm.setAlarmCode(TsiAlarmConfigVo.SYS_00);
            alarm.setAlarmTarget(applicationName);
            alarm.setAlarmValue("Running");
            tsiDatabaseService.insertAlarmOccrHs(alarm);
            tsiDatabaseService.updateProcessState(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void onApplicationEvent(ContextClosedEvent contextClosedEvent) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TsiDatabaseService tsiDatabaseService = (TsiDatabaseService)AppUtils.getBean(TsiDatabaseService.class);
        try {
            AlarmOccrVo alarm = new AlarmOccrVo(4);
            alarm.setAlarmCode(TsiAlarmConfigVo.SYS_00);
            alarm.setAlarmTarget(applicationName);
            alarm.setAlarmValue("Terminated");
            tsiDatabaseService.insertAlarmOccrHs(alarm);
            tsiDatabaseService.updateProcessState(2);
        }
        catch (Exception e) {
            // empty catch block
        }
        log.error("Application Terminated: {}, {}", (Object)sdfDate.format(new Date()), (Object)contextClosedEvent.toString());
    }
}

