/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.service;

import com.tsi.api.server.controller.result.TscApiResultCode;
import com.tsi.api.server.dto.SystemStatusDto;
import com.tsi.api.server.error.TscSsipApiErrorCode;
import com.tsi.api.server.mybatis.TscSsipApiMapper;
import com.tsi.api.server.mybatis.TsiDatabaseMapper;
import com.tsi.api.server.mybatis.vo.AlarmOccrVo;
import com.tsi.api.server.repository.TsiAlarmManager;
import com.tsi.api.server.vo.ApiInvokeVo;
import com.tsi.api.server.vo.AuthorizedVo;
import com.tsi.api.server.vo.BrokerVo;
import com.tsi.api.server.vo.KafkaAuthorizedVo;
import com.tsi.api.server.vo.NodeVo;
import com.tsi.api.server.vo.SystemStatusVo;
import com.tsi.api.server.vo.TsiAlarmConfigVo;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TscSsipApiService {
    private final TscSsipApiMapper tscSsipApiMapper;
    private final TsiDatabaseMapper tsiDatabaseMapper;

    public TscSsipApiService(TscSsipApiMapper tscSsipApiMapper, TsiDatabaseMapper tsiDatabaseMapper) {
        this.tscSsipApiMapper = tscSsipApiMapper;
        this.tsiDatabaseMapper = tsiDatabaseMapper;
    }

    @Transactional(readOnly=true)
    public List<NodeVo> getNodeInfoList() {
        return this.tscSsipApiMapper.getNodeInfoList();
    }

    @Transactional(readOnly=true)
    public AuthorizedVo getApiAuthorizedInfo(String apiId, String apiToken) {
        return this.tscSsipApiMapper.getApiAuthorizedInfo(apiId, apiToken);
    }

    public TscApiResultCode getTscAuthorizedInfo(String apiId, String apiToken, String remoteIP) {
        AuthorizedVo authorized = this.getApiAuthorizedInfo(apiId, apiToken);
        if (authorized == null) {
            return TscApiResultCode.FAIL_APITOKEN_AUTH;
        }
        if (authorized.getIsAuthorized() == 0) {
            return TscApiResultCode.FAIL_APITOKEN_EXPIRED;
        }
        String[] ipAddrs = authorized.getAccessIpAddress().replaceAll(" ", "").split(",");
        HashSet<String> setIpAddrs = new HashSet<String>(Arrays.asList(ipAddrs));
        if (setIpAddrs.contains("*") || setIpAddrs.contains(remoteIP)) {
            return TscApiResultCode.SUCCESS;
        }
        return TscApiResultCode.FAIL_UNREGI_IPADDR;
    }

    public TscSsipApiErrorCode getAuthorizedInfo(String apiId, String apiToken, String remoteIP) {
        AuthorizedVo authorized = this.getApiAuthorizedInfo(apiId, apiToken);
        if (authorized == null) {
            return TscSsipApiErrorCode.UNREGISTERED_APITOKEN;
        }
        if (authorized.getIsAuthorized() == 0) {
            return TscSsipApiErrorCode.APITOKEN_EXPIRED;
        }
        String[] ipAddrs = authorized.getAccessIpAddress().replaceAll(" ", "").split(",");
        HashSet<String> setIpAddrs = new HashSet<String>(Arrays.asList(ipAddrs));
        if (setIpAddrs.contains("*") || setIpAddrs.contains(remoteIP)) {
            return TscSsipApiErrorCode.SUCCESS;
        }
        return TscSsipApiErrorCode.DENIED_IPADDR;
    }

    public KafkaAuthorizedVo getApiKafkaAuthorizedInfo(String apiToken) {
        return this.tscSsipApiMapper.getApiKafkaAuthorizedInfo(apiToken);
    }

    public KafkaAuthorizedVo getKafkaAuthorizedInfo(String apiToken, String remoteIP, boolean checkIpAddr) {
        KafkaAuthorizedVo authorized = this.getApiKafkaAuthorizedInfo(apiToken);
        if (authorized == null) {
            authorized = new KafkaAuthorizedVo();
            authorized.setErrorCode(TscSsipApiErrorCode.UNREGISTERED_APITOKEN);
        } else if (authorized.getIsAuthorized() == 0) {
            authorized.setErrorCode(TscSsipApiErrorCode.APITOKEN_EXPIRED);
        } else if (checkIpAddr) {
            String[] ipAddrs = authorized.getAccessIpAddress().replaceAll(" ", "").split(",");
            HashSet<String> setIpAddrs = new HashSet<String>(Arrays.asList(ipAddrs));
            if (setIpAddrs.contains("*") || setIpAddrs.contains(remoteIP)) {
                authorized.setErrorCode(TscSsipApiErrorCode.SUCCESS);
                return authorized;
            }
        } else {
            authorized.setErrorCode(TscSsipApiErrorCode.SUCCESS);
            return authorized;
        }
        authorized.setErrorCode(TscSsipApiErrorCode.DENIED_IPADDR);
        return authorized;
    }

    public BrokerVo getBrokerInfo(String apiToken) {
        return this.tscSsipApiMapper.getBrokerInfo(apiToken);
    }

    public int insertInvokeHs(ApiInvokeVo invokeVo, boolean isAlarm) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        invokeVo.setEventDt(sdf.format(date));
        if (isAlarm) {
            TsiAlarmConfigVo alarmConfig = null;
            String alarmCode = TsiAlarmConfigVo.API_01;
            if (invokeVo.getApiId().contains("kafka")) {
                alarmConfig = TsiAlarmManager.getInstance().get(TsiAlarmConfigVo.KAFKA_03);
                alarmCode = TsiAlarmConfigVo.KAFKA_03;
            } else {
                alarmConfig = TsiAlarmManager.getInstance().get(TsiAlarmConfigVo.API_01);
            }
            if (alarmConfig != null) {
                AlarmOccrVo alarm = new AlarmOccrVo(4);
                alarm.setAlarmCode(alarmCode);
                alarm.setAlarmTarget(invokeVo.getApiId());
                alarm.setAlarmValue(invokeVo.getApiToken() + ", " + String.valueOf(invokeVo.getError()));
                this.tsiDatabaseMapper.insertAlarmOccrHs(alarm);
            }
        }
        return this.tscSsipApiMapper.insertInvokeHs(invokeVo);
    }

    public int updateSystemInfo(SystemStatusDto info) {
        return this.tscSsipApiMapper.insertSystemInfo(info);
    }

    public int insertSystemStatusHs(SystemStatusVo info) {
        return this.tscSsipApiMapper.insertSystemStatusHs(info);
    }
}

