/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.service;

import com.tsi.api.server.error.TscSsipApiErrorCode;
import com.tsi.api.server.mybatis.TscSsipAppMapper;
import com.tsi.api.server.mybatis.TsiDatabaseMapper;
import com.tsi.api.server.mybatis.vo.AlarmOccrVo;
import com.tsi.api.server.repository.TsiAlarmManager;
import com.tsi.api.server.vo.ApiInvokeVo;
import com.tsi.api.server.vo.DeviceInfo;
import com.tsi.api.server.vo.NaviAuthorizedVo;
import com.tsi.api.server.vo.NodeStatusVo;
import com.tsi.api.server.vo.TsiAlarmConfigVo;
import com.tsi.api.server.vo.VersionVo;
import com.tsi.app.common.app.AppUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TscSsipAppService {
    private static final Logger log = LoggerFactory.getLogger(TscSsipAppService.class);
    private final TscSsipAppMapper tscNaviApiMapper;
    private final TsiDatabaseMapper tsiDatabaseMapper;

    public TscSsipAppService(TsiDatabaseMapper tsiDatabaseMapper) {
        this.tsiDatabaseMapper = tsiDatabaseMapper;
        this.tscNaviApiMapper = (TscSsipAppMapper)AppUtils.getBean(TscSsipAppMapper.class);
    }

    @Transactional(readOnly=true)
    public List<NodeStatusVo> getNodeStatusList() {
        return this.tscNaviApiMapper.getNodeStatusList();
    }

    @Transactional(readOnly=true)
    public NaviAuthorizedVo getApiAuthorizedInfo(String apiId, String deviceId) {
        return this.tscNaviApiMapper.getDeviceAuthorizedInfo(apiId, deviceId);
    }

    public TscSsipApiErrorCode getAuthorizedInfo(String apiId, String deviceId, String remoteIP) {
        NaviAuthorizedVo authorized = this.getApiAuthorizedInfo(apiId, deviceId);
        if (authorized == null) {
            return TscSsipApiErrorCode.UNREGISTERED_APITOKEN;
        }
        log.info("{}", (Object)authorized.toString());
        if (!authorized.getUseYn().equals("Y")) {
            return TscSsipApiErrorCode.NOT_AVAILABLE;
        }
        if (!authorized.getState().equals("C")) {
            return TscSsipApiErrorCode.PENDING_REGISTRATION;
        }
        if (!authorized.getExpired().equals("N")) {
            return TscSsipApiErrorCode.APITOKEN_EXPIRED;
        }
        return TscSsipApiErrorCode.SUCCESS;
    }

    public int registerDevice(DeviceInfo deviceInfo) {
        return this.tscNaviApiMapper.registerDevice(deviceInfo);
    }

    public List<VersionVo> getVersion() {
        return this.tscNaviApiMapper.getVersion();
    }

    public int insertInvokeHs(ApiInvokeVo invokeVo, boolean isAlarm) {
        TsiAlarmConfigVo alarmConfig;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        invokeVo.setEventDt(sdf.format(date));
        if (isAlarm && (alarmConfig = TsiAlarmManager.getInstance().get(TsiAlarmConfigVo.API_01)) != null) {
            AlarmOccrVo alarm = new AlarmOccrVo(4);
            alarm.setAlarmCode(TsiAlarmConfigVo.API_01);
            alarm.setAlarmTarget(invokeVo.getApiId());
            alarm.setAlarmValue(invokeVo.getApiToken() + ", " + String.valueOf(invokeVo.getError()));
            this.tsiDatabaseMapper.insertAlarmOccrHs(alarm);
        }
        return this.tscNaviApiMapper.insertInvokeHs(invokeVo);
    }
}

