/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.repository;

import com.tsi.api.server.mybatis.vo.ProcessStateVo;
import com.tsi.api.server.vo.TsiAlarmConfigVo;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiAlarmManager {
    private static final Logger log = LoggerFactory.getLogger(TsiAlarmManager.class);
    private static TsiAlarmManager _instance = null;
    private ConcurrentHashMap<String, TsiAlarmConfigVo> tsiAlarmConfigMap = new ConcurrentHashMap();
    private ProcessStateVo processStateVo = new ProcessStateVo(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TsiAlarmManager getInstance() {
        if (_instance != null) return _instance;
        Class<TsiAlarmManager> clazz = TsiAlarmManager.class;
        synchronized (TsiAlarmManager.class) {
            if (_instance != null) return _instance;
            _instance = new TsiAlarmManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private TsiAlarmManager() {
    }

    public ProcessStateVo getProcessStateVo() {
        return this.processStateVo;
    }

    public TsiAlarmConfigVo get(String key) {
        return (TsiAlarmConfigVo)this.tsiAlarmConfigMap.get(key);
    }

    public void put(String key, TsiAlarmConfigVo vo) {
        this.tsiAlarmConfigMap.put(key, vo);
    }

    public int size() {
        return this.tsiAlarmConfigMap.size();
    }

    public boolean containsKey(String key) {
        return this.tsiAlarmConfigMap.containsKey(key);
    }

    public boolean checkAlarm(String code) {
        TsiAlarmConfigVo vo = this.get(code);
        return vo != null && vo.isUseYn();
    }

    public boolean isAlarm(String code, int value) {
        TsiAlarmConfigVo vo = this.get(code);
        if (vo != null && vo.isUseYn()) {
            return value > vo.getValue();
        }
        return false;
    }
}

