/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.controller;

import com.tsi.api.server.controller.result.AbstractTscSsipApiResult;
import com.tsi.api.server.controller.result.TscNaviApiResultAuthInfo;
import com.tsi.api.server.controller.result.TscNaviApiResultDeviceRegisterInfo;
import com.tsi.api.server.controller.result.TscNaviApiResultNodeStatusInfo;
import com.tsi.api.server.controller.result.TscSsipApiResultError;
import com.tsi.api.server.error.TscSsipApiErrorCode;
import com.tsi.api.server.service.TscSsipAppService;
import com.tsi.api.server.util.ApiUtils;
import com.tsi.api.server.vo.ApiInvokeVo;
import com.tsi.api.server.vo.DeviceInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TscSsipAppController {
    private static final Logger log = LoggerFactory.getLogger(TscSsipAppController.class);
    private final String NAVI_NODE_STATUS = "/app/nodes/{deviceId}";
    private final String NAVI_DEVICE_AUTH = "/app/auth/{deviceId}";
    private final String NAVI_DEVICE_REGISTER = "/app/devices";
    private final String NAVI_DOWNLOADS = "/app/download/{fileName}";
    private final String NAVI_API_UUID = "/app/uuid";
    private final TscSsipAppService tscNaviApiService;

    public TscSsipAppController(TscSsipAppService tscNaviApiService) {
        this.tscNaviApiService = tscNaviApiService;
    }

    @GetMapping(value={"/app/nodes/{deviceId}"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> getNodeStatus(@PathVariable(value="deviceId") String deviceId, HttpServletRequest request) {
        String apiId = "/app/nodes/{deviceId}";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, deviceId});
        ApiInvokeVo apiInvokeVo = ApiInvokeVo.builder().apiId(apiId).apiToken(deviceId).ipAddr(remoteIP).error(TscSsipApiErrorCode.SUCCESS.getCode()).build();
        try {
            TscSsipApiErrorCode authorizedInfo = this.tscNaviApiService.getAuthorizedInfo(apiId, deviceId, remoteIP);
            if (authorizedInfo != TscSsipApiErrorCode.SUCCESS) {
                log.error("\uc778\uc99d\uc624\ub958: [{}] ==> [{}]: [{}].[{}]" + apiId, new Object[]{remoteIP, deviceId, authorizedInfo.getCode(), authorizedInfo.getMessage()});
                apiInvokeVo.setError(authorizedInfo.getCode());
                this.tscNaviApiService.insertInvokeHs(apiInvokeVo, false);
                TscSsipApiResultError error = new TscSsipApiResultError(authorizedInfo.getCode(), authorizedInfo.getMessage());
                return new ResponseEntity((Object)error, HttpStatus.UNAUTHORIZED);
            }
        }
        catch (Exception e) {
            log.error("getNodeStatus: {}", (Object)e.getMessage());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        TscNaviApiResultNodeStatusInfo result = new TscNaviApiResultNodeStatusInfo(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        result.setStatusList(this.tscNaviApiService.getNodeStatusList());
        result.setCount(result.getStatusList().size());
        this.tscNaviApiService.insertInvokeHs(apiInvokeVo, false);
        log.info("NodeStatus: {}, {}", (Object)deviceId, (Object)result.toString());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @GetMapping(value={"/app/auth/{deviceId}"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> getDeviceAuthInfo(@PathVariable(value="deviceId") String deviceId, HttpServletRequest request) {
        String apiId = "/app/auth/{deviceId}";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, deviceId});
        ApiInvokeVo apiInvokeVo = ApiInvokeVo.builder().apiId(apiId).apiToken(deviceId).ipAddr(remoteIP).error(TscSsipApiErrorCode.SUCCESS.getCode()).build();
        TscSsipApiErrorCode authorizedInfo = null;
        TscNaviApiResultAuthInfo result = null;
        try {
            authorizedInfo = this.tscNaviApiService.getAuthorizedInfo(apiId, deviceId, remoteIP);
            result = new TscNaviApiResultAuthInfo(authorizedInfo.getCode(), authorizedInfo.getMessage());
            if (authorizedInfo == TscSsipApiErrorCode.SUCCESS) {
                List versionList = this.tscNaviApiService.getVersion();
                log.info("version list: {}", (Object)versionList.toString());
                result.setVersions(versionList);
            }
        }
        catch (Exception e) {
            log.error("getDeviceAuthInfo: {}", (Object)e.getMessage());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        this.tscNaviApiService.insertInvokeHs(apiInvokeVo, true);
        log.info("Auth: {}, {}", (Object)deviceId, (Object)result.toString());
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @PostMapping(value={"/app/devices"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<AbstractTscSsipApiResult> registerDevice(@RequestBody DeviceInfo deviceInfo, HttpServletRequest request) {
        String apiId = "/app/devices";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, deviceInfo.toString()});
        try {
            this.tscNaviApiService.registerDevice(deviceInfo);
        }
        catch (Exception e) {
            log.error("registerDevice: {}", (Object)e.getMessage().toString());
            TscSsipApiResultError error = new TscSsipApiResultError(TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getCode(), TscSsipApiErrorCode.ERROR_INTERNAL_DATA.getMessage());
            return new ResponseEntity((Object)error, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        TscNaviApiResultDeviceRegisterInfo result = new TscNaviApiResultDeviceRegisterInfo(TscSsipApiErrorCode.SUCCESS.getCode(), TscSsipApiErrorCode.SUCCESS.getMessage());
        result.setResult("ok");
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @GetMapping(value={"/app/download/{fileName}"})
    public ResponseEntity<Resource> download(@PathVariable(value="fileName") String fileName, HttpServletRequest request) {
        String apiId = "/app/download/{fileName}";
        String remoteIP = ApiUtils.getRemoteIP((HttpServletRequest)request);
        log.info("{}, {}, {}", new Object[]{apiId, remoteIP, fileName});
        try {
            String separator = System.getProperty("file.separator");
            String fileFullName = System.getProperty("user.dir") + separator + "download" + separator + fileName;
            Path path = Paths.get(fileFullName, new String[0]);
            File file2Upload = path.toFile();
            String contentType = "application/download";
            InputStreamResource resource = new InputStreamResource(Files.newInputStream(path, new OpenOption[0]));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", contentType);
            headers.setContentLength(file2Upload.length());
            headers.setContentDisposition(ContentDisposition.parse((String)("attachment; filename=\"" + fileName + "\";")));
            return new ResponseEntity((Object)resource, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (IOException e) {
            log.error("download: {}", (Object)e.toString());
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/app/uuid"})
    public String getUUID() {
        String uid = UUID.randomUUID().toString();
        uid = uid.replace("-", "").toUpperCase();
        return uid;
    }
}

