/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.scheduler;

import com.tsi.api.server.mybatis.TsiDatabaseService;
import com.tsi.app.common.utils.TimeUtils;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class TsiScheduler {
    private static final Logger log = LoggerFactory.getLogger(TsiScheduler.class);
    private final TsiDatabaseService tsiDatabaseService;

    public TsiScheduler(TsiDatabaseService tsiDatabaseService) {
        this.tsiDatabaseService = tsiDatabaseService;
    }

    @PreDestroy
    public void onShutDown() {
    }

    @Async
    @Scheduled(cron="0 * * * * *")
    public void jobLoadDatabase() {
        long startTime = System.nanoTime();
        int res = this.tsiDatabaseService.loadAlarmConfig();
        this.tsiDatabaseService.updateProcessState(1);
        log.info("      loadAlarmConfig: {} EA, {} {}.", new Object[]{res, TimeUtils.elapsedTime((long)startTime), Thread.currentThread().getName()});
    }

    @Async
    @Scheduled(cron="0/10 * * * * *")
    public void jobUpdateSystemStatus() {
        long startTime = System.nanoTime();
        int res = this.tsiDatabaseService.updateSystemStatus();
        log.info("jobUpdateSystemStatus: {} EA, {} {}.", new Object[]{res, TimeUtils.elapsedTime((long)startTime), Thread.currentThread().getName()});
    }
}

