/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.mybatis;

import com.tsi.api.server.mybatis.TscSsipApiMapper;
import com.tsi.api.server.mybatis.TsiDatabaseMapper;
import com.tsi.api.server.mybatis.vo.AlarmConfigVo;
import com.tsi.api.server.mybatis.vo.AlarmOccrVo;
import com.tsi.api.server.repository.TsiAlarmManager;
import com.tsi.api.server.repository.TsiSystemStatusManager;
import com.tsi.api.server.vo.SystemStatusVo;
import com.tsi.api.server.vo.TsiAlarmConfigVo;
import com.tsi.app.common.app.AppUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TsiDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(TsiDatabaseService.class);
    private TsiDatabaseMapper tsiDatabaseMapper;
    private TscSsipApiMapper tscSsipApiMapper;

    @PostConstruct
    void init() {
        this.tsiDatabaseMapper = (TsiDatabaseMapper)AppUtils.getBean(TsiDatabaseMapper.class);
        this.tscSsipApiMapper = (TscSsipApiMapper)AppUtils.getBean(TscSsipApiMapper.class);
        this.initDatabase();
        this.loadDatabase();
    }

    public void initDatabase() {
    }

    public void loadDatabase() {
    }

    public int loadAlarmConfig() {
        List objLists = this.tsiDatabaseMapper.getAlarmConfig();
        for (AlarmConfigVo obj : objLists) {
            TsiAlarmConfigVo alarm = TsiAlarmManager.getInstance().get(obj.getAlarmCode());
            if (alarm != null) {
                alarm.setDesc(obj.getDesc());
                alarm.setValue(obj.getValue());
                alarm.setUseYn(obj.getUseYn().equals("Y"));
                continue;
            }
            alarm = new TsiAlarmConfigVo();
            alarm.setAlarmCode(obj.getAlarmCode());
            alarm.setDesc(obj.getDesc());
            alarm.setValue(obj.getValue());
            alarm.setUseYn(obj.getUseYn().equals("Y"));
            TsiAlarmManager.getInstance().put(obj.getAlarmCode(), alarm);
        }
        return objLists.size();
    }

    public int insertAlarmOccrHs(AlarmOccrVo vo) {
        int res = 0;
        try {
            res = this.tsiDatabaseMapper.insertAlarmOccrHs(vo);
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        return res;
    }

    public int updateProcessState(int flag) {
        int res = 0;
        try {
            res = flag == 0 ? this.tsiDatabaseMapper.updateProcessStatusStart(TsiAlarmManager.getInstance().getProcessStateVo()) : (flag == 1 ? this.tsiDatabaseMapper.updateProcessStatusRun(TsiAlarmManager.getInstance().getProcessStateVo()) : this.tsiDatabaseMapper.updateProcessStatusStop(TsiAlarmManager.getInstance().getProcessStateVo()));
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        return res;
    }

    public int updateSystemStatus() {
        int job = 0;
        long currTm = System.currentTimeMillis();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMddHHmmss");
        String clctDt = sdfDate.format(new Date());
        for (Map.Entry obj : TsiSystemStatusManager.getInstance().getMap().entrySet()) {
            SystemStatusVo status = (SystemStatusVo)obj.getValue();
            status.setClctDt(clctDt);
            if (status.isUpdate() || currTm - status.getUpdateTm() <= 20000L) {
                AlarmOccrVo memAlarm;
                try {
                    this.tscSsipApiMapper.insertSystemStatusHs(status);
                    ++job;
                }
                catch (Exception e) {
                    log.error("{}", (Object)e.getMessage());
                }
                if (TsiAlarmManager.getInstance().checkAlarm(TsiAlarmConfigVo.SYS_01)) {
                    TsiAlarmConfigVo config1 = TsiAlarmManager.getInstance().get(TsiAlarmConfigVo.SYS_01);
                    if (status.getUseCpuRate() > (float)config1.getValue()) {
                        AlarmOccrVo cpuAlarm = new AlarmOccrVo(4);
                        cpuAlarm.setAlarmCode(TsiAlarmConfigVo.SYS_01);
                        cpuAlarm.setAlarmTarget(status.getHostName());
                        cpuAlarm.setAlarmValue(Float.toString(status.getUseCpuRate()));
                        this.tsiDatabaseMapper.insertAlarmOccrHs(cpuAlarm);
                    }
                }
                if (TsiAlarmManager.getInstance().checkAlarm(TsiAlarmConfigVo.SYS_02)) {
                    TsiAlarmConfigVo config2 = TsiAlarmManager.getInstance().get(TsiAlarmConfigVo.SYS_02);
                    if (status.getUseMemRate() > (float)config2.getValue()) {
                        memAlarm = new AlarmOccrVo(4);
                        memAlarm.setAlarmCode(TsiAlarmConfigVo.SYS_02);
                        memAlarm.setAlarmTarget(status.getHostName());
                        memAlarm.setAlarmValue(Float.toString(status.getUseCpuRate()));
                        this.tsiDatabaseMapper.insertAlarmOccrHs(memAlarm);
                    }
                }
                if (TsiAlarmManager.getInstance().checkAlarm(TsiAlarmConfigVo.SYS_03)) {
                    TsiAlarmConfigVo config3 = TsiAlarmManager.getInstance().get(TsiAlarmConfigVo.SYS_03);
                    if (status.getUseDiskRate() > (float)config3.getValue()) {
                        memAlarm = new AlarmOccrVo(4);
                        memAlarm.setAlarmCode(TsiAlarmConfigVo.SYS_03);
                        memAlarm.setAlarmTarget(status.getHostName());
                        memAlarm.setAlarmValue(Float.toString(status.getUseCpuRate()));
                        this.tsiDatabaseMapper.insertAlarmOccrHs(memAlarm);
                    }
                }
            }
            status.setUpdate(false);
        }
        return job;
    }

    public TsiDatabaseMapper getTsiDatabaseMapper() {
        return this.tsiDatabaseMapper;
    }

    public TscSsipApiMapper getTscSsipApiMapper() {
        return this.tscSsipApiMapper;
    }

    public void setTsiDatabaseMapper(TsiDatabaseMapper tsiDatabaseMapper) {
        this.tsiDatabaseMapper = tsiDatabaseMapper;
    }

    public void setTscSsipApiMapper(TscSsipApiMapper tscSsipApiMapper) {
        this.tscSsipApiMapper = tscSsipApiMapper;
    }
}

