/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.api.server.service;

import com.tsi.api.server.dto.KafkaTokenDto;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Base64;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TscSsipKafkaTokenService {
    private static final Logger log = LoggerFactory.getLogger(TscSsipKafkaTokenService.class);
    private String secretKey = "kafka-tsc-secret-key";

    @PostConstruct
    protected void init() {
        log.info("************************************************ before: {}", (Object)this.secretKey);
        this.secretKey = Base64.getEncoder().encodeToString(this.secretKey.getBytes());
        log.info("************************************************ -after: {}", (Object)this.secretKey);
    }

    public KafkaTokenDto generateToken(String apiToken, String uid, String pwd, String role) {
        long tokenPeriod = 600000L;
        long refreshPeriod = 7776000000L;
        Claims claims = Jwts.claims().setId(uid).setSubject(pwd);
        claims.put((Object)"role", (Object)role);
        claims.put((Object)"apiToken", (Object)apiToken);
        Date now = new Date();
        return new KafkaTokenDto(Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(new Date(now.getTime() + tokenPeriod)).signWith(SignatureAlgorithm.HS256, this.secretKey).compact(), Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(new Date(now.getTime() + refreshPeriod)).signWith(SignatureAlgorithm.HS256, this.secretKey).compact());
    }

    public KafkaTokenDto decode(String token) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token);
            KafkaTokenDto kafkaTokenDto = new KafkaTokenDto();
            kafkaTokenDto.setApiToken((String)((Claims)claims.getBody()).get((Object)"apiToken"));
            kafkaTokenDto.setUid(((Claims)claims.getBody()).getId());
            kafkaTokenDto.setPwd(((Claims)claims.getBody()).getSubject());
            return kafkaTokenDto;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean verifyToken(String token) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token);
            return ((Claims)claims.getBody()).getExpiration().after(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getUid(String token) {
        return ((Claims)Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token).getBody()).getSubject();
    }
}

