/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.dbms;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.utils.Elapsed;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.comm.server.mybatis.TsiDatabaseMapper;
import com.tsi.comm.server.mybatis.vo.AbstractDbmsVo;
import com.tsi.comm.server.mybatis.vo.AlarmOccrVo;
import com.tsi.comm.server.mybatis.vo.CommStatusVo;
import com.tsi.comm.server.mybatis.vo.KafkaTransVo;
import com.tsi.comm.server.mybatis.vo.NodeStatusVo;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiCvimDbmsWorker
extends AbstractTsiCvimWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimDbmsWorker.class);
    private final LinkedBlockingQueue<Object> DATA_QUEUE;
    private final TsiDatabaseMapper tsiDatabaseMapper;

    public TsiCvimDbmsWorker(int idx, int qSize) {
        this.idx = idx;
        this.qSize = qSize;
        this.DATA_QUEUE = new LinkedBlockingQueue(qSize);
        this.tsiDatabaseMapper = (TsiDatabaseMapper)AppUtils.getBean(TsiDatabaseMapper.class);
    }

    @Override
    public void run() {
        log.info("{} Start. QSIZE: {}", (Object)Thread.currentThread().getName(), (Object)this.qSize);
        while (true) {
            try {
                while (true) {
                    Object object;
                    if ((object = this.DATA_QUEUE.take()) != null) {
                        this.process(object);
                        continue;
                    }
                    Thread.yield();
                }
            }
            catch (Exception e) {
                log.error("Exception: {}", (Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    public boolean add(Object object) {
        boolean offer = false;
        try {
            offer = this.DATA_QUEUE.offer(object);
            if (!offer) {
                log.error("Packet Queue.offer: {}/{}, Queue Full: {} EA, {}, {}", new Object[]{object.getClass().getSimpleName(), this.DATA_QUEUE.size(), this.qSize, object, Thread.currentThread().getName()});
            }
        }
        catch (Exception e) {
            log.error("Packet Queue.offer: Exception: {}, {}, {}", new Object[]{object.toString(), Thread.currentThread().getName(), e.getMessage()});
        }
        return offer;
    }

    public void process(Object object) {
        Elapsed elapsed = new Elapsed();
        String job = "Unknown";
        int count = 0;
        if (object instanceof AbstractDbmsVo) {
            AbstractDbmsVo dbmsVo = (AbstractDbmsVo)object;
            if (dbmsVo.getDbmsType() == 2) {
                this.tsiDatabaseMapper.insertCommTpsHs((CommStatusVo)dbmsVo);
                job = "CommTpHs";
                count = 1;
            } else if (dbmsVo.getDbmsType() == 3) {
                this.tsiDatabaseMapper.insertKafkaTransHs((KafkaTransVo)dbmsVo);
                job = "KafkaTransHs";
                count = 1;
            } else if (dbmsVo.getDbmsType() == 1) {
                this.tsiDatabaseMapper.updateNodeStatus((NodeStatusVo)object);
                job = "NodeStatus";
                count = 1;
            } else if (dbmsVo.getDbmsType() == 4) {
                this.tsiDatabaseMapper.insertAlarmOccrHs((AlarmOccrVo)object);
                job = "AlarmOccr";
                count = 1;
            }
        } else {
            log.error("Unknown Object Class: {}", (Object)object.getClass().getSimpleName());
        }
        log.info("{}: {} EA. {} {}", new Object[]{job, count, TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds()), Thread.currentThread().getName()});
    }

    public void report() {
        long avgTime = 0L;
        log.info("Packet: Remain Q: {}, Average: {}, {}", new Object[]{this.DATA_QUEUE.size(), TimeUtils.elapsedTimeStr((long)avgTime), Thread.currentThread().getName()});
    }
}

