/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.utils.Counter;
import com.tsi.app.common.xnet.NetUtils;
import com.tsi.comm.server.mybatis.vo.CommStatusVo;
import com.tsi.comm.server.mybatis.vo.KafkaTransVo;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.repository.TsiSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiTpmsManager {
    private static final Logger log = LoggerFactory.getLogger(TsiTpmsManager.class);
    private static TsiTpmsManager _instance = null;
    private TsiCvimDbmsProcess tsiCvimDbmsService;
    private Counter readTPS = new Counter();
    private Counter readTPM = new Counter();
    private Counter readTPD = new Counter();
    private Counter readBPS = new Counter();
    private Counter readBPM = new Counter();
    private Counter readBPD = new Counter();
    private KafkaTransVo kafkaTransVo = new KafkaTransVo(3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TsiTpmsManager getInstance() {
        if (_instance != null) return _instance;
        Class<TsiTpmsManager> clazz = TsiTpmsManager.class;
        synchronized (TsiTpmsManager.class) {
            if (_instance != null) return _instance;
            _instance = new TsiTpmsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private TsiTpmsManager() {
        this.kafkaTransVo.setHostName(NetUtils.getHostName());
        this.tsiCvimDbmsService = (TsiCvimDbmsProcess)AppUtils.getBean(TsiCvimDbmsProcess.class);
    }

    public KafkaTransVo getKafkaTransVo() {
        return this.kafkaTransVo;
    }

    public void readPacket(TsiCpuPacket packet) {
        this.readTPS.increment();
        this.readBPS.add((long)packet.getBuf().length);
        this.readTPM.increment();
        this.readBPM.add((long)packet.getBuf().length);
        this.readTPD.increment();
        this.readBPD.add((long)packet.getBuf().length);
    }

    public void resetSecond() {
        CommStatusVo stat = new CommStatusVo(2);
        long trans = this.readTPS.reset();
        long bytes = this.readBPS.reset();
        stat.setTrans(trans);
        stat.setBytes(bytes);
        stat.setSessions(TsiSessionManager.getInstance().get());
        this.tsiCvimDbmsService.add((Object)stat, (int)Thread.currentThread().getId());
    }

    public void resetMinute() {
        long trans = this.readTPM.reset();
        long bytes = this.readBPM.reset();
    }

    public void resetDay() {
        long trans = this.readTPD.reset();
        long bytes = this.readBPD.reset();
    }
}

