/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.packet;

import com.tsi.app.common.app.AppUtils;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.process.AbstractTsiCvimProcess;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.packet.TsiCvimPacketWorker;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.repository.TsiNodeManager;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimPacketProcess
extends AbstractTsiCvimProcess {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimPacketProcess.class);
    private final KafkaProducerService kafkaProducerService;

    public TsiCvimPacketProcess(KafkaProducerService kafkaProducerService) {
        this.kafkaProducerService = kafkaProducerService;
    }

    @PostConstruct
    void init() {
        int qSize;
        int nodes;
        ThreadGroup workerGroup = new ThreadGroup("packetProcess");
        TsiCvimServerConfig tsiCvimServerConfig = (TsiCvimServerConfig)AppUtils.getBean(TsiCvimServerConfig.class);
        this.workers = tsiCvimServerConfig.getPacketWorkers();
        if (this.workers <= 0) {
            this.workers = 1;
        }
        if ((nodes = TsiNodeManager.getInstance().size()) > (qSize = tsiCvimServerConfig.getQueueSize())) {
            qSize = nodes;
        }
        qSize *= 4;
        qSize /= this.workers;
        for (int ii = 0; ii < this.workers; ++ii) {
            TsiCvimPacketWorker packetWorker = new TsiCvimPacketWorker(ii, qSize, this.kafkaProducerService);
            this.workerList.add(packetWorker);
            Thread worker = new Thread(workerGroup, (Runnable)packetWorker);
            worker.setName(String.format("pktWorker-%02d.%02d", this.workers, ii + 1));
            worker.setDaemon(true);
            this.threadList.add(worker);
        }
        for (Thread worker : this.threadList) {
            worker.start();
        }
    }

    public boolean add(Object object, int idx) {
        boolean offer = false;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        try {
            offer = ((AbstractTsiCvimWorker)this.workerList.get(idx %= this.workers)).add((Object)packet);
        }
        catch (Exception e) {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.error("QUEUE_DATA.add: Exception: {}, {}", (Object)packet.getNodeId(), (Object)e.getMessage());
            MDC.clear();
        }
        return offer;
    }

    public void stop() {
    }

    public void report() {
        for (AbstractTsiCvimWorker worker : this.workerList) {
            worker.report();
        }
    }

    public KafkaProducerService getKafkaProducerService() {
        return this.kafkaProducerService;
    }
}

