/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.scheduler;

import com.tsi.app.common.utils.Elapsed;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.comm.server.kafka.KafkaConsumerService;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.mybatis.TsiDatabaseService;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.repository.TsiTpmsManager;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class TsiCommScheduler {
    private static final Logger log = LoggerFactory.getLogger(TsiCommScheduler.class);
    private final TsiDatabaseService tsiDatabaseService;
    private final KafkaProducerService kafkaProducerService;
    private final KafkaConsumerService kafkaConsumerService;

    public TsiCommScheduler(TsiDatabaseService tsiDatabaseService, KafkaProducerService kafkaProducerService, KafkaConsumerService kafkaConsumerService) {
        this.tsiDatabaseService = tsiDatabaseService;
        this.kafkaProducerService = kafkaProducerService;
        this.kafkaConsumerService = kafkaConsumerService;
    }

    @PreDestroy
    public void onShutDown() {
    }

    @Async
    @Scheduled(cron="* * * * * *")
    public void staticsForPacketSecond() {
        Elapsed elapsed = new Elapsed();
        TsiTpmsManager.getInstance().resetSecond();
        log.info("{}", (Object)String.format("%25s: %s", "staticsForPacketSecond", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
    }

    @Async
    @Scheduled(cron="0/5 * * * * *")
    public void checkKafkaServerAlive() {
        Elapsed elapsed = new Elapsed();
        this.kafkaConsumerService.start();
        this.kafkaProducerService.sendPing();
        log.info("{}", (Object)String.format("%25s: %s", "checkKafkaServerAlive", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
    }

    @Async
    @Scheduled(cron="0/5 * * * * *")
    public void checkSessionTimeout() {
        if (!TsiAlarmManager.getInstance().checkAlarm(TsiAlarmConfigVo.COMM_02)) {
            return;
        }
        Elapsed elapsed = new Elapsed();
        long timeout = 0L;
        TsiAlarmConfigVo vo = TsiAlarmManager.getInstance().get(TsiAlarmConfigVo.COMM_02);
        if (vo == null) {
            return;
        }
        timeout = vo.getValue() * 1000;
        if (timeout <= 0L) {
            log.error("checkSessionTimeout: timeout value error: {}", (Object)timeout);
            return;
        }
        TsiNodeManager.getInstance().checkSessionTimeout(timeout);
        log.info("{}", (Object)String.format("%25s: %s", "checkSessionTimeout", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
    }

    @Async
    @Scheduled(cron="0/10 * * * * *")
    public void reportNodeSessionAlive() {
        Elapsed elapsed = new Elapsed();
        TsiNodeManager.getInstance().reportNodeSessions();
        TsiSessionManager.getInstance().reportChannelSessions();
        log.info("{}", (Object)String.format("%25s: %s", "reportNodeSessionAlive", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
    }

    @Async
    @Scheduled(cron="0 * * * * *")
    public void staticsForPacketMinute() {
        Elapsed elapsed = new Elapsed();
        TsiTpmsManager.getInstance().resetMinute();
        log.info("{}", (Object)String.format("%25s: %s", "staticsForPacketMinute", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
    }

    @Async
    @Scheduled(cron="0 0 0 * * *")
    public void staticsForPacketDay() {
        Elapsed elapsed = new Elapsed();
        TsiTpmsManager.getInstance().resetDay();
        log.info("{}", (Object)String.format("%25s: %s", "staticsForPacketDay", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
    }

    @Async
    @Scheduled(cron="0 * * * * *")
    public void loadBaseDatabase() {
        Elapsed elapsed = new Elapsed();
        this.tsiDatabaseService.loadDatabase();
        this.tsiDatabaseService.updateProcessState(1);
        log.info("{}", (Object)String.format("%25s: %s", "loadBaseDatabase", TimeUtils.elapsedTimeStr((long)elapsed.nanoSeconds())));
    }
}

