/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.kafka;

import com.tsi.app.common.kafka.KafkaProducerFactory;
import com.tsi.comm.server.config.TsiKafkaProducerConfig;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.repository.TsiTpmsManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Service
public class KafkaProducerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerService.class);
    private final TsiKafkaProducerConfig config;
    private final TsiCvimDbmsProcess tsiCvimDbmsService;
    private KafkaTemplate<String, byte[]> cvimProducer;
    private KafkaTemplate<String, byte[]> nodeProducer;
    private KafkaTemplate<String, byte[]> testProducer;
    private KafkaTemplate<String, Long> pingProducer;

    public KafkaProducerService(TsiKafkaProducerConfig config, TsiCvimDbmsProcess tsiCvimDbmsService) {
        this.config = config;
        this.tsiCvimDbmsService = tsiCvimDbmsService;
    }

    @PostConstruct
    void init() {
        if (this.config.isMultiConnect()) {
            if (this.config.isEnableCvim()) {
                this.cvimProducer = KafkaProducerFactory.createByteArrayTemplate((String)this.config.getCvimServers(), (List)this.config.props);
                this.cvimProducer.setDefaultTopic("cvim-raw");
            }
            if (this.config.isEnableNode()) {
                this.nodeProducer = KafkaProducerFactory.createByteArrayTemplate((String)this.config.getNodeServers(), (List)this.config.props);
            }
            if (this.config.isEnableTest()) {
                this.testProducer = KafkaProducerFactory.createByteArrayTemplate((String)this.config.getTestServers(), (List)this.config.props);
                this.testProducer.setDefaultTopic("topic-for-ssd-test");
            }
        } else {
            KafkaTemplate producer = KafkaProducerFactory.createByteArrayTemplate((String)this.config.getBootstrapServers(), (List)this.config.props);
            if (this.config.isEnableCvim()) {
                this.cvimProducer = producer;
            }
            if (this.config.isEnableNode()) {
                this.nodeProducer = producer;
            }
            if (this.config.isEnableTest()) {
                this.testProducer = producer;
                this.testProducer.setDefaultTopic("topic-for-ssd-test");
            }
        }
        this.createPingProducer();
        log.info("[{}] ------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]   cvimProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.cvimProducer);
        log.info("[{}]   nodeProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.nodeProducer);
        log.info("[{}]   testProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.testProducer);
        log.info("[{}]   pingProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.pingProducer);
    }

    public void createPingProducer() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.config.getBootstrapServers());
        props.put("acks", this.config.getConsumerAckConfig());
        props.put("retries", 0);
        props.put("linger.ms", 1);
        props.put("request.timeout.ms", 3000);
        props.put("delivery.timeout.ms", 4000);
        props.put("transaction.timeout.ms", 3000);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", LongSerializer.class);
        this.pingProducer = KafkaProducerFactory.createProducerTemplate(props);
        this.pingProducer.setDefaultTopic("cvim_ping");
    }

    public void shutdown() {
        try {
            if (this.cvimProducer != null) {
                this.cvimProducer.destroy();
            }
            if (this.nodeProducer != null) {
                this.nodeProducer.destroy();
            }
            if (this.testProducer != null) {
                this.testProducer.destroy();
            }
            if (this.pingProducer != null) {
                this.pingProducer.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean initPartitions() {
        List partitionInfos;
        try {
            if (this.testProducer != null) {
                partitionInfos = this.testProducer.partitionsFor("topic-for-ssd-test");
                log.info("{} partitions: {}", (Object)"topic-for-ssd-test", (Object)partitionInfos);
            }
        }
        catch (Exception e) {
            log.error("Request partitionFor {}: {}", (Object)"topic-for-ssd-test", (Object)e.toString());
            return false;
        }
        try {
            if (this.cvimProducer != null) {
                partitionInfos = this.cvimProducer.partitionsFor("cvim-raw");
                log.info("{} partitions: {}", (Object)"cvim-raw", (Object)partitionInfos);
            }
        }
        catch (Exception e) {
            log.error("Request partitionFor {}: {}", (Object)"cvim-raw", (Object)e.toString());
            return false;
        }
        return true;
    }

    public void sendPing() {
        if (this.pingProducer == null) {
            log.info("sendPing: pingProducer == null");
            return;
        }
        long sendNanoTime = System.nanoTime();
        TsiTpmsManager.getInstance().getKafkaTransVo().setSendNanoTime(sendNanoTime);
        TsiTpmsManager.getInstance().getKafkaTransVo().setSendTm(0L);
        TsiTpmsManager.getInstance().getKafkaTransVo().setRecvTm(0L);
        ListenableFuture future = this.pingProducer.sendDefault((Object)"key", (Object)sendNanoTime);
        future.addCallback((ListenableFutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void sendCvim(long key, byte[] data) {
        if (this.cvimProducer != null) {
            try {
                if (this.config.isMultiConnect()) {
                    this.cvimProducer.sendDefault((Object)Long.toString(key), (Object)data);
                } else {
                    this.cvimProducer.send("cvim-raw", (Object)Long.toString(key), (Object)data);
                }
            }
            catch (Exception e) {
                log.error("sendCvim: {}, {}: {}", new Object[]{"cvim-raw", key, e.toString()});
            }
        }
    }

    public void sendNode(String key, byte[] data) {
        if (this.nodeProducer != null) {
            try {
                this.nodeProducer.send(key, (Object)key, (Object)data);
            }
            catch (Exception e) {
                log.error("sendNode: {}, {}: {}", new Object[]{key, key, e.toString()});
            }
        }
    }

    public void sendTest(long key, byte[] data) {
        if (this.testProducer != null) {
            try {
                this.testProducer.sendDefault((Object)Long.toString(key), (Object)data);
            }
            catch (Exception e) {
                log.error("sendTest: {}, {}: {}", new Object[]{"topic-for-ssd-test", key, e.toString()});
            }
        }
    }

    protected void send(KafkaTemplate<String, byte[]> kafka, String topic, String key, byte[] data) {
        try {
            kafka.send(topic, (Object)key, (Object)data);
        }
        catch (Exception e) {
            log.error("kafka.send: {}, Exception: {}", (Object)topic, (Object)e.getMessage());
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ TsiKafkaProducerConfig access$100(KafkaProducerService x0) {
        return x0.config;
    }

    static /* synthetic */ TsiCvimDbmsProcess access$200(KafkaProducerService x0) {
        return x0.tsiCvimDbmsService;
    }
}

