/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.kafka.security.auth.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tsi.kafka.security.auth.api.result.TscSsipApiResultKafkaAuth;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.springframework.boot.configurationprocessor.json.JSONArray;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;

public class HttpUtils {
    public static void get(String strUrl) {
        try {
            URL url = new URL(strUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            con.setRequestMethod("GET");
            con.setDoOutput(false);
            StringBuilder sb = new StringBuilder();
            if (con.getResponseCode() == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();
                System.out.println("" + sb.toString());
            } else {
                System.out.println(con.getResponseMessage());
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static void post(String strUrl, String jsonMessage) {
        try {
            URL url = new URL(strUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setDefaultUseCaches(false);
            OutputStreamWriter wr = new OutputStreamWriter(con.getOutputStream());
            wr.write(jsonMessage);
            wr.flush();
            StringBuilder sb = new StringBuilder();
            if (con.getResponseCode() == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();
                System.out.println("" + sb.toString());
            } else {
                System.out.println(con.getResponseMessage());
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static void callApi(String apiUrl, JSONObject params, String type) {
        HttpURLConnection conn = null;
        JSONObject responseJson = null;
        try {
            URL url = new URL(apiUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(type);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Transfer-Encoding", "chunked");
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setDoOutput(true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
            JSONObject commands = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonOutput = gson.toJson((Object)params);
            bw.write(params.toString());
            bw.flush();
            bw.close();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                String line = "";
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                responseJson = new JSONObject(sb.toString());
                System.out.println("responseJson :: " + responseJson);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static TscSsipApiResultKafkaAuth getKafkaLoginAuth(String apiUrl, JSONObject params) {
        TscSsipApiResultKafkaAuth result = new TscSsipApiResultKafkaAuth(0, "Success");
        result.setResult("0");
        HttpURLConnection conn = null;
        JSONObject responseJson = null;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            URL url = new URL(apiUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json;utf-8");
            conn.setRequestProperty("Accept", "application/json");
            conn.setDoOutput(true);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));
            JSONObject commands = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonOutput = gson.toJson((Object)params);
            bw.write(params.toString());
            bw.flush();
            bw.close();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                String line = "";
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                responseJson = new JSONObject(sb.toString());
                result = (TscSsipApiResultKafkaAuth)objectMapper.readValue(sb.toString(), TscSsipApiResultKafkaAuth.class);
                System.out.println("responseJson :: " + responseJson);
            } else {
                result.setResult(String.valueOf(responseCode));
            }
        }
        catch (MalformedURLException e) {
            result.setResult("11");
            e.printStackTrace();
        }
        catch (IOException e) {
            result.setResult("12");
            e.printStackTrace();
        }
        catch (JSONException e) {
            result.setResult("13");
            e.printStackTrace();
        }
        return result;
    }

    public static void main1(String[] args) {
        String token = "YOUR_ACCESS_TOKEN";
        String header = "Bearer " + token;
        try {
            String inputLine;
            String apiURL = "https://openapi.naver.com/v1/nid/me";
            URL url = new URL(apiURL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("Authorization", header);
            int responseCode = con.getResponseCode();
            BufferedReader br = responseCode == 200 ? new BufferedReader(new InputStreamReader(con.getInputStream())) : new BufferedReader(new InputStreamReader(con.getErrorStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            br.close();
            System.out.println(response.toString());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main2(String[] args) {
        String clientId = "YOUR_CLIENT_ID";
        String clientSecret = "YOUR_CLIENT_SECRET";
        try {
            String inputLine;
            String text = URLEncoder.encode("\uc548\ub155\ud558\uc138\uc694. \uc624\ub298 \uae30\ubd84\uc740 \uc5b4\ub5bb\uc2b5\ub2c8\uae4c?", "UTF-8");
            String apiURL = "https://openapi.naver.com/v1/papago/n2mt";
            URL url = new URL(apiURL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("X-Naver-Client-Id", clientId);
            con.setRequestProperty("X-Naver-Client-Secret", clientSecret);
            String postParams = "source=ko&target=en&text=" + text;
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(postParams);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            BufferedReader br = responseCode == 200 ? new BufferedReader(new InputStreamReader(con.getInputStream())) : new BufferedReader(new InputStreamReader(con.getErrorStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            br.close();
            System.out.println(response.toString());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void RestCall(String paramUrl, JSONObject jsonObject) {
        try {
            URL url = new URL(paramUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("X-Data-Type", "application/json");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            osw.write(jsonObject.toString());
            osw.flush();
            osw.close();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            if (conn.getResponseCode() != 200) {
                System.out.println("Failed: HTTP error code : " + conn.getResponseCode());
                throw new RuntimeException("Failed: HTTP error code : " + conn.getResponseCode());
            }
            System.out.println("\ubc1c\uc1a1 \uc131\uacf5");
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            conn.disconnect();
        }
        catch (IOException e) {
            System.out.println("RestCall Fail : " + e.getMessage());
        }
    }
}

