/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.kafka.security.auth;

import com.tsi.kafka.security.auth.api.HttpUtils;
import com.tsi.kafka.security.auth.api.result.TscSsipApiResultKafkaAuth;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.plain.PlainAuthenticateCallback;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONObject;

public class TsiKafkaLoginCallback
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(TsiKafkaLoginCallback.class);
    private static final String JAAS_USER_PREFIX = "user_";
    private List<AppConfigurationEntry> jaasConfigEntries;
    private String apiUrl;

    public void close() {
        log.info("close");
    }

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        log.info("******* configs: {}", configs);
        log.info("******* saslMechanism: {}", (Object)saslMechanism);
        log.info("******* AppConfigurationEntry: {}", (Object)jaasConfigEntries.toString());
        this.jaasConfigEntries = jaasConfigEntries;
        Map<String, ?> ops = jaasConfigEntries.get(0).getOptions();
        this.apiUrl = (String)ops.get("apiUrl");
        log.info("******* apiUrl: {}", (Object)this.apiUrl);
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String userName = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                userName = ((NameCallback)callback).getDefaultName();
                log.info("******* userName: {}", (Object)userName);
                log.info("******* getName: {}", (Object)((NameCallback)callback).getName());
                continue;
            }
            if (callback instanceof PlainAuthenticateCallback) {
                PlainAuthenticateCallback plainAuthenticateCallback = (PlainAuthenticateCallback)callback;
                log.debug("******* plainAuthenticateCallback.password(): {}", (Object)plainAuthenticateCallback.password());
                boolean authenticated = this.authenticate(userName, plainAuthenticateCallback.password());
                plainAuthenticateCallback.authenticated(authenticated);
                continue;
            }
            if (callback instanceof ScramCredentialCallback) {
                ((ScramCredentialCallback)callback).scramCredential(this.credential(userName));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private boolean authenticate(String userName, char[] password) throws IOException {
        String secret = String.valueOf(password);
        log.info("******* authenticate: userName: {}, password: {}, {}", new Object[]{userName, password, secret});
        if (userName == null || userName.length() == 0 || secret.isEmpty()) {
            return false;
        }
        String expectedPassword = JaasContext.configEntryOption(this.jaasConfigEntries, (String)(JAAS_USER_PREFIX + userName), (String)PlainLoginModule.class.getName());
        log.debug("******* expectedPassword: userName: {}, expectedPassword: [{}], {}", new Object[]{userName, expectedPassword, secret});
        if (expectedPassword != null && expectedPassword.equals(secret)) {
            log.debug("******* authenticate: security Ok........");
            return true;
        }
        if (userName.equals("test") && secret.equals("test-secret")) {
            log.debug("******* authenticate: dynamic user security Ok........");
            return true;
        }
        if (userName.equals("test1") && secret.equals("test1-secret")) {
            log.debug("******* authenticate: dynamic user security Ok........");
            return true;
        }
        try {
            JSONObject params = new JSONObject();
            params.put("apiToken", (Object)userName);
            params.put("accessToken", (Object)secret);
            TscSsipApiResultKafkaAuth result = HttpUtils.getKafkaLoginAuth(this.apiUrl, params);
            if (result != null && result.getResult().equals("0")) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private ScramCredential credential(String userName) {
        return null;
    }
}

