package com.tsi.sig.server;

import com.tsi.sig.server.app.AppUtils;
import com.tsi.sig.server.mapper.MainMapper;
import com.tsi.sig.server.repository.ApplicationRepository;
import com.tsi.sig.server.vo.CvibNodeVO;
import com.tsi.sig.server.websocket.AllTopicCvimHandler;
import com.tsi.sig.server.websocket.EvpTopicHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.scheduling.annotation.EnableAsync;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Slf4j
@EnableAsync
@Configuration
@SpringBootApplication
@ComponentScan(basePackages = {"com.tsi.sig.server.app", "com.tsi.sig.server.config", "com.tsi.sig.server.mapper", "com.tsi.sig.server"})
public class TsiSigServerApplication implements CommandLineRunner, ApplicationListener<ContextClosedEvent>, InitializingBean, DisposableBean {

    private static final String applicationName = "tsi-sig-server";

    public static void main(String[] args) {
        SpringApplication application = new SpringApplicationBuilder()
                .sources(TsiSigServerApplication.class)
                .listeners(new ApplicationPidFileWriter("./conf/" + applicationName + ".pid"))
                .build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
        /*SpringApplication.run(TsiWebServerApplication.class, args);*/
    }

    @Override
    public void run(String... args) throws Exception, RuntimeException {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                               TSI CVIM System                                  **");
        log.info("**                         CVIM Signal Server Program.                            **");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", sdfDate.format(new Date()));
        log.info("************************************************************************************");

        AllTopicCvimHandler allTopicCvimHandler = (AllTopicCvimHandler) AppUtils.getBean(AllTopicCvimHandler.class);
        EvpTopicHandler evpTopicHandler = (EvpTopicHandler) AppUtils.getBean(EvpTopicHandler.class);
        //OneTopicCvimHandler oneTopicCvimHandler = (OneTopicCvimHandler) AppUtils.getBean(OneTopicCvimHandler.class);
        MainMapper mapper = (MainMapper)AppUtils.getBean(MainMapper.class);
        ApplicationRepository repo = (ApplicationRepository) AppUtils.getBean(ApplicationRepository.class);
        List<CvibNodeVO> list = mapper.getNodeList();
        repo.getNodeList().clear();
        for (CvibNodeVO vo : list) {
            repo.getNodeList().add(vo);
        }
        allTopicCvimHandler.start();
        evpTopicHandler.start();
        //oneTopicCvimHandler.start();
    }

    @Override
    public void onApplicationEvent(ContextClosedEvent contextClosedEvent) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        log.error("Application Terminated: {}, {}", sdfDate.format(new Date()), contextClosedEvent.toString());
    }

    @Override
    public void afterPropertiesSet() throws Exception, RuntimeException {
        //System.err.println("InitializingBean 인터페이스 구현 메서드입니다. 'Bean'이 생성될 때 마다 호출되는 메서드 입니다.");
    }
    @Override
    public void destroy() throws Exception, RuntimeException {
        //System.err.println("DisposableBean 인터페이스 구현 메서드입니다. 'Bean'이 소멸될 때 마다 호출되는 메서드입니다");
    }

}
