package com.tsi.sig.server.controller;

import com.tsi.sig.server.objects.UserVO;
import com.tsi.sig.server.service.MainService;
import com.tsi.sig.server.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.text.ParseException;
import java.util.*;

@Slf4j
@Controller
public class MainController {
    private final MainService mainService;
    public MainController(MainService mainService) {
        this.mainService = mainService;
    }

//    @RequestMapping(value="/login.do")
//    public String page() {
//        System.out.println("=======================================login.do====================");
//        return "login";
//    }

    @RequestMapping(value="/error.do")
    public String error(){
        //log.info("CALL.........................................: error");
        return "error";
    }

    @RequestMapping({"/main.do"})
    public String home(HttpServletRequest request, Model model) {
        HttpSession session = request.getSession();
        SecurityContext member = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
        model.addAttribute("center", this.mainService.getCenterCode());
        return member == null ? "login" : "main_new";
    }

    @RequestMapping({"/refreshNodeList.do"})
    @ResponseBody
    public ResultVo refreshNodeList(HttpServletRequest request, HttpServletResponse response) {
        return mainService.refreshNodeList();
    }

    @GetMapping("/errorHistory.do")
    public String errorList(Model model){
        model.addAttribute("region_list", this.mainService.getRegionCd());
        return "errorHistory";
    }

    @RequestMapping({"/userEdit.do"})
    public String userEdit() {
        return "userEdit";
    }

    @RequestMapping(value = "/getBottomListFrame.do")
    public String getBottomListFrame() {
        //log.info("CALL.........................................: getBottomListFrame");
        return "bottomListFrame_new";
    }

    @RequestMapping(value = "/getTreeListFrame.do")
    public String getTreeListFrame(Model model) {
        //log.info("CALL.........................................: getTreeListFrame");
        model.addAttribute("center", this.mainService.getCenterCode());
        return "treeListFrame_Tree";
//        return "treeListFrame_new";
//        return "treeListFrame";
    }

    @RequestMapping(value = "/getIntTreeList.do", method = RequestMethod.POST)
    public @ResponseBody
    List<CvibNodeVO> getIntTreeList() {
        //log.info("CALL.........................................: getIntTreeList");
        List<CvibNodeVO> nodes = mainService.getLodeList();
        //log.info("getIntTreeList: {}", nodes.toString());
        return nodes;
    }

    @RequestMapping(value = "/getSignalInfo.do", method = RequestMethod.POST)
    public @ResponseBody
    List<CvibNodeVO> getSignalInfo(@RequestParam Map<String,String> paramMap, HttpServletResponse response) {
        List<CvibNodeVO> nodes = mainService.getRegionList(paramMap);
        response.setContentType("application/json; charset=UTF-8");
        return nodes;
    }

    @RequestMapping(value = "/cvibInfoDetail.do", method = RequestMethod.GET)
    public String cvibInfoDetail(@RequestParam("nodeId") String nodeId, Model model) {
        //log.info("CALL.........................................: cvibInfoDetail");
        model.addAttribute("nodeId", nodeId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("nodeId", nodeId);
        List<CvibNodeVO> nodes = mainService.getCvibNodeInfo(paramMap);
        CvibNodeVO node = null;
        if (nodes != null && nodes.size() > 0) {
            node = nodes.get(0);
        }
        model.addAttribute("node", node);
        return "cvibInfoDetail_new";
//        return "cvibInfoDetail";
    }

    @RequestMapping(value = "/getCvibList.do", method = RequestMethod.POST)
    @ResponseBody
    public Map<String,List<?>> cvibInfoList(@RequestParam Map<String, String> paramMap) throws ParseException, AuthenticationException {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal != null && principal != "anonymousUser") {
            UserVO user = (UserVO)principal;
            String[] test = new String[]{"I", "B", "N", "M", "S"};
            List<String> strList = new ArrayList<>(Arrays.asList(test));
            if ( strList.contains(user.getUserGrade())) {
                return mainService.getCvibNodeStatusList(paramMap);
            }
            else {
                throw new AuthenticationException("사용자 권한을 확인해주세요.");
            }
        }
        throw new AuthenticationException("로그인 하지않고 API 를 사용할 수 없습니다.");
    }
    @RequestMapping(value = "/getCvibDetail.do", method = RequestMethod.POST)
    @ResponseBody
    public CvibNodeStatusVo getCvibDetail(String nodeId) {
        return mainService.getCvibNodeDetail(nodeId);
    }

    @RequestMapping(value = "/getEvpsInfo.do", method = RequestMethod.POST)
    @ResponseBody
    public List<EvpServiceVo> getEvpsInfoList(){
        return mainService.getEvpServiceList();
    }

//    @RequestMapping(value = "/getEvpServiceList.do", method = RequestMethod.POST)
//    @ResponseBody
//    public List<EvpServiceVo> getEvpServiceList() {
//        return mainService.getEvpServiceList();
//    }
    @RequestMapping(value = "/getEvpRouteList.do", method = RequestMethod.POST)
    @ResponseBody
    public List<EvpRouteVo> getEvpRouteList(@RequestParam HashMap<String,Object> paramMap) {
        return mainService.getEvpRouteList(paramMap);
    }

    @RequestMapping(value = "/getEvpHistory.do", method = RequestMethod.POST)
    @ResponseBody
    public List<EvpServiceVo> getEvpHistory(@RequestParam HashMap<String,Object> paramMap) {
        return mainService.getEvpHistoryList(paramMap);
    }

    @RequestMapping(value = "/getCenterCode.do", method = RequestMethod.POST)
    @ResponseBody
    public List<EvpCenterVo> getCenterCode() {
        return mainService.getCenterCode();
    }

    @PostMapping("/getNodeStatistics.do")
    @ResponseBody
    public List<NodeStatisticsVo> getNodeStatistics(@RequestParam Map<String, Object> paramMap){
        return mainService.getNodeStatistics(paramMap);
    }

    @PostMapping("/getNodeStatusCntStat.do")
    @ResponseBody
    public List<NodeStatisticsVo> getNodeStatusCntStat(@RequestParam Map<String, Object> paramMap){
        return mainService.getNodeStatusCntStat(paramMap);
    }
}
