package com.tsi.sig.server.controller;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.Date;

@Controller
@Slf4j
public class TsiSigServerController {
    private final Integer processId = 90020;
    private final String bootingTime;

    public TsiSigServerController() {
        this.bootingTime = now();
    }

    private String now() {
        Date today = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(today);
    }

    @GetMapping("/info")
    @ResponseBody
    public String info() {
        String sep = System.lineSeparator();
        String heading = "---------------------------------------------------------";

        StringBuilder sb = new StringBuilder();
        sb.append(heading).append(sep);
        sb.append("UTIC Wireless Signal Monitoring Server").append(sep);
        sb.append(heading).append(sep);
        sb.append(String.format("Process Id: %s, %s, %s", this.processId, this.bootingTime, now())).append(sep);
        sb.append(heading).append(sep);
        sb.append("OK").append(sep);
        return sb.toString();
    }
}
