package com.tsi.sig.server.controller;

import com.tsi.sig.server.objects.UserVO;
import com.tsi.sig.server.service.UserService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@Controller
public class UserController {
    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @PostMapping({"/getUserList.do"})
    @ResponseBody
    public List<UserVO> getUserList()  {
        List<UserVO> users = this.userService.getUserList();
        return users;
    }
}
