package com.tsi.sig.server.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 긴급차량 이벤트 정보
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EvpsEventDto implements KafkaEvpsData {

    /**
     * 긴급차량 서비스 ID
     */
    private String serviceId;
    /**
     * 수집시각
     */
    private String clctDt;
    /**
     * 긴급차량 번호(Not Used)
     */
    private String evNo;
    /**
     * 이벤트 코드(0:서비스시작, 1:차량위치, 2:서비스종료)
     */
    private Integer eventCd;
    /**
     * 현재위치 위도
     */
    private Double curLat;
    /**
     * 현재위치 경로
     */
    private Double curLng;
    /**
     * 현재 차량 속도
     */
    private Integer curSpd;
    /**
     * 목적지 남은거리(m)
     */
    private Integer remDist;
}
