package com.tsi.sig.server.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * 긴급차량 서비스 정보
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EvpsServiceDto implements KafkaEvpsData {

    /**
     * 긴급차량 서비스 ID
     */
    private String serviceId;
    /**
     * 수집시각
     */
    private String clctDt;
    /**
     * 긴급차량 번호
     */
    private String evNo;
    /**
     * 현재위치 위도
     */
    private Double curLat;
    /**
     * 현재위치 경로
     */
    private Double curLng;
    /**
     * 서비스명(목적지명)
     */
    private String serviceNm;
    /**
     * 도착위치 위도
     */
    private Double arrLat;
    /**
     * 도착위치 위도
     */
    private Double arrLng;
    /**
     * 예상도착시간(단위:초)
     */
    private Integer arrTm;
    /**
     * 차량길이(군집차량길이포함)
     */
    private Integer vehLen;
    /**
     * 재난번호
     */
    private String ocrNo;
    /**
     * 재난종별명
     */
    private String ocrType;
    /**
     * 거리(단위:m)
     */
    private Integer serviceDist;

    /**
     * 상태 코드
     */
    private Integer statusCd;

    @Builder.Default
    private List<RouteInfo> routeList = new ArrayList<>();

}
